/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.logging.slf4j;

import java.io.Serializable;
import java.util.function.Consumer;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.jline.MessageUtils;
import org.mvndaemon.mvnd.logging.slf4j.MvndBaseLogger;
import org.mvndaemon.mvnd.logging.slf4j.SimpleLoggerConfiguration;

public class MvndSimpleLogger
extends MvndBaseLogger {
    static Consumer<String> LOG_SINK;
    private transient String shortLogName = null;

    public static void setLogSink(Consumer<String> logSink) {
        LOG_SINK = logSink;
    }

    MvndSimpleLogger(String name) {
        super(name);
        this.configure(MvndSimpleLogger.CONFIG_PARAMS.defaultLogLevel);
    }

    @Override
    void write(StringBuilder buf, Throwable t) {
        this.writeThrowable(t, buf);
        Consumer<String> sink = LOG_SINK;
        if (sink != null) {
            sink.accept(buf.toString());
        } else {
            MvndSimpleLogger.CONFIG_PARAMS.outputChoice.getTargetPrintStream().println(buf.toString());
        }
    }

    @Override
    protected String renderLevel(int level) {
        switch (level) {
            case 0: {
                return MessageUtils.builder().trace((Object)"TRACE").build();
            }
            case 10: {
                return MessageUtils.builder().debug((Object)"DEBUG").build();
            }
            case 20: {
                return MessageUtils.builder().info((Object)"INFO").build();
            }
            case 30: {
                return MessageUtils.builder().warning((Object)"WARNING").build();
            }
        }
        return MessageUtils.builder().error((Object)"ERROR").build();
    }

    protected void writeThrowable(Throwable t, StringBuilder sb) {
        if (t == null) {
            return;
        }
        MessageBuilder builder = MessageUtils.builder();
        builder.failure((Object)t.getClass().getName());
        if (t.getMessage() != null) {
            builder.a((CharSequence)": ");
            builder.failure((Object)t.getMessage());
        }
        builder.newline();
        sb.append(builder);
        this.printStackTrace(t, builder, "");
    }

    private void printStackTrace(Throwable t, MessageBuilder builder, String prefix) {
        for (StackTraceElement stackTraceElement : t.getStackTrace()) {
            builder.a((CharSequence)prefix);
            builder.a((CharSequence)"    ");
            builder.strong((Object)"at");
            builder.a((CharSequence)(" " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName()));
            builder.a((CharSequence)" (").strong((Object)this.getLocation(stackTraceElement)).a((CharSequence)")");
            builder.newline();
        }
        for (Serializable serializable : t.getSuppressed()) {
            this.writeThrowable((Throwable)serializable, builder, "Suppressed", prefix + "    ");
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            this.writeThrowable(cause, builder, "Caused by", prefix);
        }
    }

    private void writeThrowable(Throwable t, MessageBuilder builder, String caption, String prefix) {
        builder.a((CharSequence)prefix).strong((Object)caption).a((CharSequence)": ").a((CharSequence)t.getClass().getName());
        if (t.getMessage() != null) {
            builder.a((CharSequence)": ");
            builder.failure((Object)t.getMessage());
        }
        builder.newline();
        this.printStackTrace(t, builder, prefix);
    }

    protected String getLocation(StackTraceElement e) {
        assert (e != null);
        if (e.isNativeMethod()) {
            return "Native Method";
        }
        if (e.getFileName() == null) {
            return "Unknown Source";
        }
        if (e.getLineNumber() >= 0) {
            return String.format("%s:%s", e.getFileName(), e.getLineNumber());
        }
        return e.getFileName();
    }

    public void configure(int defaultLogLevel) {
        String levelString = this.recursivelyComputeLevelString();
        this.currentLogLevel = levelString != null ? SimpleLoggerConfiguration.stringToLevel(levelString) : defaultLogLevel;
    }

    public void setLogLevel(int logLevel) {
        this.currentLogLevel = logLevel;
    }
}

