/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.Session;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.internal.impl.DefaultSession;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;

@Singleton
@Named
public class DefaultSessionFactory {
    private final RepositorySystem repositorySystem;
    private final MavenRepositorySystem mavenRepositorySystem;
    private final Lookup lookup;
    private final RuntimeInformation runtimeInformation;

    @Inject
    public DefaultSessionFactory(RepositorySystem repositorySystem, MavenRepositorySystem mavenRepositorySystem, Lookup lookup, RuntimeInformation runtimeInformation) {
        this.repositorySystem = repositorySystem;
        this.mavenRepositorySystem = mavenRepositorySystem;
        this.lookup = lookup;
        this.runtimeInformation = runtimeInformation;
    }

    public InternalSession newSession(MavenSession mavenSession) {
        DefaultSession session = new DefaultSession(mavenSession, this.repositorySystem, null, this.mavenRepositorySystem, this.lookup, this.runtimeInformation);
        InternalSession.associate((RepositorySystemSession)mavenSession.getRepositorySession(), (Session)session);
        return session;
    }
}

