/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.DependencyScope;
import org.apache.maven.api.Node;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.Session;
import org.apache.maven.api.services.ArtifactResolverException;
import org.apache.maven.api.services.DependencyCollector;
import org.apache.maven.api.services.DependencyCollectorException;
import org.apache.maven.api.services.DependencyCollectorRequest;
import org.apache.maven.api.services.DependencyCollectorResult;
import org.apache.maven.api.services.DependencyResolver;
import org.apache.maven.api.services.DependencyResolverException;
import org.apache.maven.api.services.DependencyResolverRequest;
import org.apache.maven.api.services.DependencyResolverResult;
import org.apache.maven.internal.impl.AbstractNode;
import org.apache.maven.internal.impl.DefaultDependencyResolverResult;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.PathModularizationCache;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;

@Named
@Singleton
public class DefaultDependencyResolver
implements DependencyResolver {
    public List<Node> flatten(Session s, Node node, PathScope scope) throws DependencyResolverException {
        InternalSession session = InternalSession.from((Session)s);
        DependencyNode root = ((AbstractNode)Utils.cast(AbstractNode.class, (Object)node, (String)"node")).getDependencyNode();
        List dependencies = session.getRepositorySystem().flattenDependencyNodes(session.getSession(), root, DefaultDependencyResolver.getScopeDependencyFilter(scope));
        dependencies.remove(root);
        return Utils.map((Collection)dependencies, arg_0 -> ((InternalSession)session).getNode(arg_0));
    }

    private static DependencyFilter getScopeDependencyFilter(PathScope scope) {
        Set scopes = scope.dependencyScopes().stream().map(DependencyScope::id).collect(Collectors.toSet());
        return (n, p) -> {
            Dependency d = n.getDependency();
            return d == null || scopes.contains(d.getScope());
        };
    }

    public DependencyResolverResult resolve(DependencyResolverRequest request) throws DependencyCollectorException, DependencyResolverException, ArtifactResolverException {
        InternalSession session = InternalSession.from((Session)((DependencyResolverRequest)Utils.nonNull((Object)request, (String)"request")).getSession());
        Predicate filter = request.getPathTypeFilter();
        PathModularizationCache cache = new PathModularizationCache();
        DependencyCollectorResult collectorResult = ((DependencyCollector)session.getService(DependencyCollector.class)).collect((DependencyCollectorRequest)request);
        List<Node> nodes = this.flatten((Session)session, collectorResult.getRoot(), request.getPathScope());
        List coordinates = nodes.stream().map(Node::getDependency).filter(Objects::nonNull).map(Artifact::toCoordinate).collect(Collectors.toList());
        Map artifacts = session.resolveArtifacts(coordinates);
        DefaultDependencyResolverResult result = new DefaultDependencyResolverResult(cache, collectorResult.getExceptions(), collectorResult.getRoot(), nodes.size());
        for (Node node : nodes) {
            org.apache.maven.api.Dependency d = node.getDependency();
            Path path = d != null ? (Path)artifacts.get(d) : null;
            try {
                result.addDependency(node, d, filter, path);
            }
            catch (IOException e) {
                throw DefaultDependencyResolver.cannotReadModuleInfo(path, e);
            }
        }
        return result;
    }

    private static DependencyResolverException cannotReadModuleInfo(Path path, IOException cause) {
        return new DependencyResolverException("Cannot read module information of " + String.valueOf(path), (Throwable)cause);
    }
}

