/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.classrealm;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.classrealm.ArtifactClassRealmConstituent;
import org.apache.maven.classrealm.ClassRealmConstituent;
import org.apache.maven.classrealm.ClassRealmManager;
import org.apache.maven.classrealm.ClassRealmManagerDelegate;
import org.apache.maven.classrealm.ClassRealmRequest;
import org.apache.maven.classrealm.DefaultClassRealmRequest;
import org.apache.maven.extension.internal.CoreExports;
import org.apache.maven.internal.CoreRealm;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.eclipse.aether.artifact.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultClassRealmManager
implements ClassRealmManager {
    public static final String API_REALMID = "maven.api";
    private static final ClassLoader PARENT_CLASSLOADER = ClassWorld.class.getClassLoader();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ClassWorld world;
    private final ClassRealm containerRealm;
    private final List<ClassRealmManagerDelegate> delegates;
    private final ClassRealm mavenApiRealm;
    private final Set<String> providedArtifacts;

    @Inject
    public DefaultClassRealmManager(CoreRealm coreRealm, List<ClassRealmManagerDelegate> delegates, CoreExports exports) {
        this.world = coreRealm.getClassWorld();
        this.containerRealm = coreRealm.getRealm();
        this.delegates = delegates;
        Map<String, ClassLoader> foreignImports = exports.getExportedPackages();
        this.mavenApiRealm = this.createRealm(API_REALMID, ClassRealmRequest.RealmType.Core, null, null, foreignImports, null);
        this.providedArtifacts = exports.getExportedArtifacts();
    }

    private ClassRealm newRealm(String id) {
        ClassWorld classWorld = this.world;
        synchronized (classWorld) {
            Object realmId = id;
            Random random = new Random();
            while (true) {
                try {
                    ClassRealm classRealm = this.world.newRealm((String)realmId, null);
                    this.logger.debug("Created new class realm {}", realmId);
                    return classRealm;
                }
                catch (DuplicateRealmException e) {
                    realmId = id + "-" + random.nextInt();
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public ClassRealm getMavenApiRealm() {
        return this.mavenApiRealm;
    }

    private ClassRealm createRealm(String baseRealmId, ClassRealmRequest.RealmType type, ClassLoader parent, List<String> parentImports, Map<String, ClassLoader> foreignImports, List<Artifact> artifacts) {
        ArrayList<ClassRealmConstituent> constituents = new ArrayList<ClassRealmConstituent>(artifacts == null ? 0 : artifacts.size());
        if (artifacts != null && !artifacts.isEmpty()) {
            for (Artifact artifact : artifacts) {
                if (!this.isProvidedArtifact(artifact) && artifact.getFile() != null) {
                    constituents.add(new ArtifactClassRealmConstituent(artifact));
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("  Excluded: {}", (Object)DefaultClassRealmManager.getId(artifact));
            }
        }
        parentImports = parentImports != null ? new ArrayList<String>(parentImports) : new ArrayList<String>();
        foreignImports = foreignImports != null ? new TreeMap<String, ClassLoader>(foreignImports) : new TreeMap<String, ClassLoader>();
        ClassRealm classRealm = this.newRealm(baseRealmId);
        if (parent != null) {
            classRealm.setParentClassLoader(parent);
        }
        this.callDelegates(classRealm, type, parent, parentImports, foreignImports, constituents);
        this.wireRealm(classRealm, parentImports, foreignImports);
        this.populateRealm(classRealm, constituents);
        return classRealm;
    }

    @Override
    public ClassRealm getCoreRealm() {
        return this.containerRealm;
    }

    @Override
    public ClassRealm createProjectRealm(Model model, List<Artifact> artifacts) {
        Objects.requireNonNull(model, "model cannot be null");
        ClassRealm parent = this.getMavenApiRealm();
        return this.createRealm(DefaultClassRealmManager.getKey(model), ClassRealmRequest.RealmType.Project, (ClassLoader)parent, null, null, artifacts);
    }

    private static String getKey(Model model) {
        return "project>" + model.getGroupId() + ":" + model.getArtifactId() + ":" + model.getVersion();
    }

    @Override
    public ClassRealm createExtensionRealm(Plugin plugin, List<Artifact> artifacts) {
        Objects.requireNonNull(plugin, "plugin cannot be null");
        Map<String, ClassRealm> foreignImports = Collections.singletonMap("", this.getMavenApiRealm());
        return this.createRealm(DefaultClassRealmManager.getKey(plugin, true), ClassRealmRequest.RealmType.Extension, PARENT_CLASSLOADER, null, foreignImports, artifacts);
    }

    private boolean isProvidedArtifact(Artifact artifact) {
        return this.providedArtifacts.contains(artifact.getGroupId() + ":" + artifact.getArtifactId());
    }

    @Override
    public ClassRealm createPluginRealm(Plugin plugin, ClassLoader parent, List<String> parentImports, Map<String, ClassLoader> foreignImports, List<Artifact> artifacts) {
        Objects.requireNonNull(plugin, "plugin cannot be null");
        if (parent == null) {
            parent = PARENT_CLASSLOADER;
        }
        return this.createRealm(DefaultClassRealmManager.getKey(plugin, false), ClassRealmRequest.RealmType.Plugin, parent, parentImports, foreignImports, artifacts);
    }

    private static String getKey(Plugin plugin, boolean extension) {
        String version = ArtifactUtils.toSnapshotVersion((String)plugin.getVersion());
        return (extension ? "extension>" : "plugin>") + plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + version;
    }

    private static String getId(Artifact artifact) {
        return DefaultClassRealmManager.getId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getBaseVersion());
    }

    private static String getId(ClassRealmConstituent constituent) {
        return DefaultClassRealmManager.getId(constituent.getGroupId(), constituent.getArtifactId(), constituent.getType(), constituent.getClassifier(), constituent.getVersion());
    }

    private static String getId(String gid, String aid, String type, String cls, String ver) {
        return gid + ":" + aid + ":" + type + (String)(cls != null && !cls.isEmpty() ? ":" + cls : "") + ":" + ver;
    }

    private void callDelegates(ClassRealm classRealm, ClassRealmRequest.RealmType type, ClassLoader parent, List<String> parentImports, Map<String, ClassLoader> foreignImports, List<ClassRealmConstituent> constituents) {
        ArrayList<ClassRealmManagerDelegate> delegates = new ArrayList<ClassRealmManagerDelegate>(this.delegates);
        if (!delegates.isEmpty()) {
            DefaultClassRealmRequest request = new DefaultClassRealmRequest(type, parent, parentImports, foreignImports, constituents);
            for (ClassRealmManagerDelegate delegate : delegates) {
                try {
                    delegate.setupRealm(classRealm, request);
                }
                catch (Exception e) {
                    this.logger.error(delegate.getClass().getName() + " failed to setup class realm " + String.valueOf(classRealm) + ": " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void populateRealm(ClassRealm classRealm, List<ClassRealmConstituent> constituents) {
        this.logger.debug("Populating class realm {}", (Object)classRealm.getId());
        for (ClassRealmConstituent constituent : constituents) {
            File file = constituent.getFile();
            if (this.logger.isDebugEnabled()) {
                String id = DefaultClassRealmManager.getId(constituent);
                this.logger.debug("  Included: {}", (Object)id);
            }
            try {
                classRealm.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void wireRealm(ClassRealm classRealm, List<String> parentImports, Map<String, ClassLoader> foreignImports) {
        if (foreignImports != null && !foreignImports.isEmpty()) {
            this.logger.debug("Importing foreign packages into class realm {}", (Object)classRealm.getId());
            for (Map.Entry entry : foreignImports.entrySet()) {
                ClassLoader importedRealm = (ClassLoader)entry.getValue();
                String imp = (String)entry.getKey();
                this.logger.debug("  Imported: {} < {}", (Object)imp, DefaultClassRealmManager.getId(importedRealm));
                classRealm.importFrom(importedRealm, imp);
            }
        }
        if (parentImports != null && !parentImports.isEmpty()) {
            this.logger.debug("Importing parent packages into class realm {}", (Object)classRealm.getId());
            for (String string : parentImports) {
                this.logger.debug("  Imported: {} < {}", (Object)string, DefaultClassRealmManager.getId(classRealm.getParentClassLoader()));
                classRealm.importFromParent(string);
            }
        }
    }

    private static Object getId(ClassLoader classLoader) {
        if (classLoader instanceof ClassRealm) {
            return ((ClassRealm)classLoader).getId();
        }
        return classLoader;
    }
}

