/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.cli.CommandLine;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.building.Source;
import org.apache.maven.cli.CliRequest;
import org.apache.maven.cli.ResolveFile;
import org.apache.maven.cli.configuration.ConfigurationProcessor;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="settings")
@Singleton
public class SettingsXmlConfigurationProcessor
implements ConfigurationProcessor {
    public static final String HINT = "settings";
    public static final String USER_HOME = System.getProperty("user.home");
    public static final File USER_MAVEN_CONFIGURATION_HOME = new File(USER_HOME, ".m2");
    public static final File DEFAULT_USER_SETTINGS_FILE = new File(USER_MAVEN_CONFIGURATION_HOME, "settings.xml");
    public static final File DEFAULT_PROJECT_SETTINGS_FILE = new File(".mvn", "settings.xml");
    public static final File DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("maven.conf"), "settings.xml");
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsXmlConfigurationProcessor.class);
    private final SettingsBuilder settingsBuilder;
    private final SettingsDecrypter settingsDecrypter;

    @Inject
    public SettingsXmlConfigurationProcessor(SettingsBuilder settingsBuilder, SettingsDecrypter settingsDecrypter) {
        this.settingsBuilder = settingsBuilder;
        this.settingsDecrypter = settingsDecrypter;
    }

    @Override
    public void process(CliRequest cliRequest) throws Exception {
        File globalSettingsFile;
        File projectSettingsFile;
        File userSettingsFile;
        CommandLine commandLine = cliRequest.getCommandLine();
        String workingDirectory = cliRequest.getWorkingDirectory();
        MavenExecutionRequest request = cliRequest.getRequest();
        if (commandLine.hasOption('s')) {
            userSettingsFile = new File(commandLine.getOptionValue('s'));
            if (!(userSettingsFile = ResolveFile.resolveFile(userSettingsFile, workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified user settings file does not exist: " + String.valueOf(userSettingsFile));
            }
        } else {
            userSettingsFile = DEFAULT_USER_SETTINGS_FILE;
        }
        if (commandLine.hasOption("ps")) {
            projectSettingsFile = new File(commandLine.getOptionValue("ps"));
            if (!(projectSettingsFile = ResolveFile.resolveFile(projectSettingsFile, workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified project settings file does not exist: " + String.valueOf(projectSettingsFile));
            }
        } else if (cliRequest.getRootDirectory() != null) {
            projectSettingsFile = DEFAULT_PROJECT_SETTINGS_FILE;
            projectSettingsFile = ResolveFile.resolveFile(projectSettingsFile, cliRequest.getRootDirectory().toString());
        } else {
            projectSettingsFile = null;
        }
        if (commandLine.hasOption("gs")) {
            globalSettingsFile = new File(commandLine.getOptionValue("gs"));
            if (!(globalSettingsFile = ResolveFile.resolveFile(globalSettingsFile, workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified global settings file does not exist: " + String.valueOf(globalSettingsFile));
            }
        } else {
            globalSettingsFile = DEFAULT_GLOBAL_SETTINGS_FILE;
        }
        request.setGlobalSettingsFile(globalSettingsFile);
        request.setProjectSettingsFile(projectSettingsFile);
        request.setUserSettingsFile(userSettingsFile);
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
        settingsRequest.setGlobalSettingsFile(globalSettingsFile);
        settingsRequest.setProjectSettingsFile(projectSettingsFile);
        settingsRequest.setUserSettingsFile(userSettingsFile);
        settingsRequest.setSystemProperties(cliRequest.getSystemProperties());
        Properties props = cliRequest.getUserProperties();
        if (cliRequest.getRootDirectory() != null) {
            props = new Properties();
            props.putAll((Map<?, ?>)cliRequest.getUserProperties());
            props.put("session.rootDirectory", cliRequest.getRootDirectory().toString());
        }
        settingsRequest.setUserProperties(props);
        if (request.getEventSpyDispatcher() != null) {
            request.getEventSpyDispatcher().onEvent((Object)settingsRequest);
        }
        LOGGER.debug("Reading global settings from '{}'", this.getLocation((Source)settingsRequest.getGlobalSettingsSource(), settingsRequest.getGlobalSettingsFile()));
        LOGGER.debug("Reading project settings from '{}'", this.getLocation((Source)settingsRequest.getProjectSettingsSource(), settingsRequest.getProjectSettingsFile()));
        LOGGER.debug("Reading user settings from '{}'", this.getLocation((Source)settingsRequest.getUserSettingsSource(), settingsRequest.getUserSettingsFile()));
        SettingsBuildingResult settingsResult = this.settingsBuilder.build((SettingsBuildingRequest)settingsRequest);
        if (request.getEventSpyDispatcher() != null) {
            request.getEventSpyDispatcher().onEvent((Object)settingsResult);
        }
        this.populateFromSettings(request, settingsResult.getEffectiveSettings());
        if (!settingsResult.getProblems().isEmpty() && LOGGER.isWarnEnabled()) {
            LOGGER.warn("");
            LOGGER.warn("Some problems were encountered while building the effective settings");
            for (SettingsProblem problem : settingsResult.getProblems()) {
                LOGGER.warn("{} @ {}", (Object)problem.getMessage(), (Object)problem.getLocation());
            }
            LOGGER.warn("");
        }
    }

    private MavenExecutionRequest populateFromSettings(MavenExecutionRequest request, Settings settings) throws MavenExecutionRequestPopulationException {
        if (settings == null) {
            return request;
        }
        request.setOffline(settings.isOffline());
        request.setInteractiveMode(settings.isInteractiveMode());
        request.setPluginGroups(settings.getPluginGroups());
        request.setLocalRepositoryPath(settings.getLocalRepository());
        for (Server server : settings.getServers()) {
            request.addServer(server);
        }
        for (Proxy proxy : settings.getProxies()) {
            if (!proxy.isActive()) continue;
            request.addProxy(proxy);
        }
        for (Mirror mirror : settings.getMirrors()) {
            request.addMirror(mirror);
        }
        for (Repository remoteRepository : settings.getRepositories()) {
            try {
                request.addRemoteRepository(MavenRepositorySystem.buildArtifactRepository((Repository)remoteRepository));
            }
            catch (InvalidRepositoryException invalidRepositoryException) {}
        }
        for (Repository pluginRepository : settings.getPluginRepositories()) {
            try {
                request.addPluginArtifactRepository(MavenRepositorySystem.buildArtifactRepository((Repository)pluginRepository));
            }
            catch (InvalidRepositoryException invalidRepositoryException) {}
        }
        request.setActiveProfiles(settings.getActiveProfiles());
        for (Profile rawProfile : settings.getProfiles()) {
            request.addProfile(SettingsUtils.convertFromSettingsProfile((Profile)rawProfile));
            if (!settings.getActiveProfiles().contains(rawProfile.getId())) continue;
            List remoteRepositories = rawProfile.getRepositories();
            for (Repository remoteRepository : remoteRepositories) {
                try {
                    request.addRemoteRepository(MavenRepositorySystem.buildArtifactRepository((Repository)remoteRepository));
                }
                catch (InvalidRepositoryException invalidRepositoryException) {}
            }
            List pluginRepositories = rawProfile.getPluginRepositories();
            for (Repository pluginRepository : pluginRepositories) {
                try {
                    request.addPluginArtifactRepository(MavenRepositorySystem.buildArtifactRepository((Repository)pluginRepository));
                }
                catch (InvalidRepositoryException invalidRepositoryException) {}
            }
        }
        return request;
    }

    private Object getLocation(Source source, File defaultLocation) {
        if (source != null) {
            return source.getLocation();
        }
        return defaultLocation;
    }
}

