/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.extension.internal.CoreExtensionEntry;
import org.apache.maven.internal.xml.XmlNodeImpl;
import org.apache.maven.internal.xml.XmlPlexusConfiguration;
import org.apache.maven.model.v4.MavenTransformer;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

public class ExtensionConfigurationModule
implements Module {
    private final CoreExtensionEntry extension;
    private final Iterable<ValueSource> valueSources;

    public ExtensionConfigurationModule(CoreExtensionEntry extension, ValueSource ... valueSources) {
        this.extension = extension;
        this.valueSources = Arrays.asList(valueSources);
    }

    public void configure(Binder binder) {
        if (this.extension.getKey() != null) {
            XmlNode configuration = this.extension.getConfiguration();
            if (configuration == null) {
                configuration = new XmlNodeImpl("configuration");
            }
            configuration = new Interpolator().transform(configuration);
            binder.bind(XmlNode.class).annotatedWith((Annotation)Names.named((String)this.extension.getKey())).toInstance((Object)configuration);
            binder.bind(PlexusConfiguration.class).annotatedWith((Annotation)Names.named((String)this.extension.getKey())).toInstance((Object)XmlPlexusConfiguration.toPlexusConfiguration((XmlNode)configuration));
        }
    }

    class Interpolator
    extends MavenTransformer {
        final StringSearchInterpolator interpolator;

        Interpolator() {
            super(null);
            this.interpolator = new StringSearchInterpolator();
            this.interpolator.setCacheAnswers(true);
            ExtensionConfigurationModule.this.valueSources.forEach(arg_0 -> ((StringSearchInterpolator)this.interpolator).addValueSource(arg_0));
        }

        public XmlNode transform(XmlNode node) {
            return super.transform(node);
        }

        protected String transform(String str) {
            try {
                return this.interpolator.interpolate(str);
            }
            catch (InterpolationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

