/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.Dependency;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.DependencyScope;
import org.apache.maven.api.Language;
import org.apache.maven.api.Listener;
import org.apache.maven.api.LocalRepository;
import org.apache.maven.api.Node;
import org.apache.maven.api.Packaging;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.PathType;
import org.apache.maven.api.Project;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Service;
import org.apache.maven.api.SessionData;
import org.apache.maven.api.Type;
import org.apache.maven.api.Version;
import org.apache.maven.api.VersionConstraint;
import org.apache.maven.api.VersionRange;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.settings.Settings;

@Experimental
@ThreadSafe
public interface Session {
    @Nonnull
    public Settings getSettings();

    @Nonnull
    public LocalRepository getLocalRepository();

    @Nonnull
    public List<RemoteRepository> getRemoteRepositories();

    @Nonnull
    public SessionData getData();

    @Nonnull
    public Map<String, String> getUserProperties();

    @Nonnull
    public Map<String, String> getSystemProperties();

    @Nonnull
    public Map<String, String> getEffectiveProperties(@Nullable Project var1);

    @Nonnull
    public Version getMavenVersion();

    public int getDegreeOfConcurrency();

    @Nonnull
    public Instant getStartTime();

    @Nonnull
    public Path getTopDirectory();

    @Nonnull
    public Path getRootDirectory();

    @Nonnull
    public List<Project> getProjects();

    @Nonnull
    public Map<String, Object> getPluginContext(@Nonnull Project var1);

    @Nonnull
    public <T extends Service> T getService(@Nonnull Class<T> var1);

    @Nonnull
    public Session withLocalRepository(@Nonnull LocalRepository var1);

    @Nonnull
    public Session withRemoteRepositories(@Nonnull List<RemoteRepository> var1);

    public void registerListener(@Nonnull Listener var1);

    public void unregisterListener(@Nonnull Listener var1);

    @Nonnull
    public Collection<Listener> getListeners();

    @Nonnull
    public LocalRepository createLocalRepository(@Nonnull Path var1);

    @Nonnull
    public RemoteRepository createRemoteRepository(@Nonnull String var1, @Nonnull String var2);

    @Nonnull
    public RemoteRepository createRemoteRepository(@Nonnull Repository var1);

    @Nonnull
    public ArtifactCoordinate createArtifactCoordinate(@Nonnull String var1);

    @Nonnull
    public ArtifactCoordinate createArtifactCoordinate(String var1, String var2, String var3, String var4);

    @Nonnull
    public ArtifactCoordinate createArtifactCoordinate(String var1, String var2, String var3, String var4, String var5, String var6);

    @Nonnull
    public ArtifactCoordinate createArtifactCoordinate(@Nonnull Artifact var1);

    @Nonnull
    public DependencyCoordinate createDependencyCoordinate(@Nonnull ArtifactCoordinate var1);

    @Nonnull
    public DependencyCoordinate createDependencyCoordinate(@Nonnull Dependency var1);

    @Nonnull
    public Artifact createArtifact(String var1, String var2, String var3, String var4);

    @Nonnull
    public Artifact createArtifact(String var1, String var2, String var3, String var4, String var5, String var6);

    @Nonnull
    public Map.Entry<Artifact, Path> resolveArtifact(@Nonnull ArtifactCoordinate var1);

    @Nonnull
    public Map<Artifact, Path> resolveArtifacts(ArtifactCoordinate ... var1);

    @Nonnull
    public Map<Artifact, Path> resolveArtifacts(@Nonnull Collection<? extends ArtifactCoordinate> var1);

    @Nonnull
    public Map.Entry<Artifact, Path> resolveArtifact(@Nonnull Artifact var1);

    @Nonnull
    public Map<Artifact, Path> resolveArtifacts(Artifact ... var1);

    public void installArtifacts(Artifact ... var1);

    public void installArtifacts(@Nonnull Collection<Artifact> var1);

    public void deployArtifact(@Nonnull RemoteRepository var1, Artifact ... var2);

    public void setArtifactPath(@Nonnull Artifact var1, @Nonnull Path var2);

    @Nonnull
    public Optional<Path> getArtifactPath(@Nonnull Artifact var1);

    public Path getPathForLocalArtifact(@Nonnull Artifact var1);

    @Nonnull
    public Path getPathForRemoteArtifact(@Nonnull RemoteRepository var1, @Nonnull Artifact var2);

    public boolean isVersionSnapshot(@Nonnull String var1);

    @Nonnull
    public Node collectDependencies(@Nonnull Artifact var1);

    @Nonnull
    public Node collectDependencies(@Nonnull Project var1);

    @Nonnull
    public Node collectDependencies(@Nonnull DependencyCoordinate var1);

    @Nonnull
    public List<Node> flattenDependencies(@Nonnull Node var1, @Nonnull PathScope var2);

    @Nonnull
    public List<Path> resolveDependencies(@Nonnull DependencyCoordinate var1);

    @Nonnull
    public List<Path> resolveDependencies(@Nonnull List<DependencyCoordinate> var1);

    @Nonnull
    public List<Path> resolveDependencies(@Nonnull Project var1, @Nonnull PathScope var2);

    @Nonnull
    public Map<PathType, List<Path>> resolveDependencies(@Nonnull DependencyCoordinate var1, @Nonnull PathScope var2, @Nonnull Collection<PathType> var3);

    @Nonnull
    public Map<PathType, List<Path>> resolveDependencies(@Nonnull Project var1, @Nonnull PathScope var2, @Nonnull Collection<PathType> var3);

    @Nonnull
    public Version resolveVersion(@Nonnull ArtifactCoordinate var1);

    @Nonnull
    public List<Version> resolveVersionRange(@Nonnull ArtifactCoordinate var1);

    @Nonnull
    public Version parseVersion(@Nonnull String var1);

    @Nonnull
    public VersionRange parseVersionRange(@Nonnull String var1);

    @Nonnull
    public VersionConstraint parseVersionConstraint(@Nonnull String var1);

    @Nonnull
    public Type requireType(@Nonnull String var1);

    @Nonnull
    public Language requireLanguage(@Nonnull String var1);

    @Nonnull
    public Packaging requirePackaging(@Nonnull String var1);

    @Nonnull
    public ProjectScope requireProjectScope(@Nonnull String var1);

    @Nonnull
    public DependencyScope requireDependencyScope(@Nonnull String var1);

    @Nonnull
    public PathScope requirePathScope(@Nonnull String var1);
}

