/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.internal;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.internal.AbstractMavenPluginParametersValidator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class ReadOnlyPluginParametersValidator
extends AbstractMavenPluginParametersValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadOnlyPluginParametersValidator.class);

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected String getParameterLogReason(Parameter parameter) {
        return "is read-only, must not be used in configuration";
    }

    @Override
    public void validate(MojoDescriptor mojoDescriptor, PlexusConfiguration pomConfiguration, ExpressionEvaluator expressionEvaluator) {
        if (!LOGGER.isWarnEnabled()) {
            return;
        }
        mojoDescriptor.getParameters().stream().filter(parameter -> !parameter.isEditable()).forEach(parameter -> this.checkParameter((Parameter)parameter, pomConfiguration, expressionEvaluator));
    }

    protected void checkParameter(Parameter parameter, PlexusConfiguration pomConfiguration, ExpressionEvaluator expressionEvaluator) {
        PlexusConfiguration config = pomConfiguration.getChild(parameter.getName(), false);
        if (ReadOnlyPluginParametersValidator.isValueSet(config, expressionEvaluator)) {
            this.logParameter(parameter);
        }
    }
}

