/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.services.BaseRequest;

@Experimental
@Immutable
public interface ArtifactFactoryRequest {
    @Nonnull
    public Session getSession();

    public String getGroupId();

    public String getArtifactId();

    public String getVersion();

    public String getClassifier();

    public String getExtension();

    public String getType();

    public static ArtifactFactoryRequest build(Session session, String groupId, String artifactId, String version, String extension) {
        return ArtifactFactoryRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).groupId(groupId).artifactId(artifactId).version(version).extension(extension).build();
    }

    public static ArtifactFactoryRequest build(Session session, String groupId, String artifactId, String version, String classifier, String extension, String type) {
        return ArtifactFactoryRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).groupId(groupId).artifactId(artifactId).version(version).classifier(classifier).extension(extension).type(type).build();
    }

    public static ArtifactFactoryRequestBuilder builder() {
        return new ArtifactFactoryRequestBuilder();
    }

    @NotThreadSafe
    public static class ArtifactFactoryRequestBuilder {
        private Session session;
        private String groupId;
        private String artifactId;
        private String version;
        private String classifier;
        private String extension;
        private String type;

        ArtifactFactoryRequestBuilder() {
        }

        public ArtifactFactoryRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        public ArtifactFactoryRequestBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public ArtifactFactoryRequestBuilder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public ArtifactFactoryRequestBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ArtifactFactoryRequestBuilder classifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public ArtifactFactoryRequestBuilder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public ArtifactFactoryRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ArtifactFactoryRequest build() {
            return new DefaultArtifactFactoryRequest(this.session, this.groupId, this.artifactId, this.version, this.classifier, this.extension, this.type);
        }

        private static class DefaultArtifactFactoryRequest
        extends BaseRequest
        implements ArtifactFactoryRequest {
            private final String groupId;
            private final String artifactId;
            private final String version;
            private final String classifier;
            private final String extension;
            private final String type;

            DefaultArtifactFactoryRequest(@Nonnull Session session, String groupId, String artifactId, String version, String classifier, String extension, String type) {
                super(session);
                this.groupId = groupId;
                this.artifactId = artifactId;
                this.version = version;
                this.classifier = classifier;
                this.extension = extension;
                this.type = type;
            }

            @Override
            public String getGroupId() {
                return this.groupId;
            }

            @Override
            public String getArtifactId() {
                return this.artifactId;
            }

            @Override
            public String getVersion() {
                return this.version;
            }

            @Override
            public String getClassifier() {
                return this.classifier;
            }

            @Override
            public String getExtension() {
                return this.extension;
            }

            @Override
            public String getType() {
                return this.type;
            }
        }
    }
}

