/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.transform.pull;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.maven.model.transform.pull.BufferingParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class NodeBufferingParser
extends BufferingParser {
    private final List<BufferingParser.Event> buffer = new ArrayList<BufferingParser.Event>();
    private final String nodeName;
    private boolean buffering;

    public NodeBufferingParser(XmlPullParser xmlPullParser, String nodeName) {
        super(xmlPullParser);
        this.nodeName = Objects.requireNonNull(nodeName);
    }

    @Override
    protected boolean accept() throws XmlPullParserException, IOException {
        if (this.nodeName.equals(this.xmlPullParser.getName())) {
            if (this.xmlPullParser.getEventType() == 2 && !this.buffering) {
                this.buffer.add(this.bufferEvent());
                this.buffering = true;
                return false;
            }
            if (this.xmlPullParser.getEventType() == 3 && this.buffering) {
                this.buffer.add(this.bufferEvent());
                this.process(this.buffer);
                this.buffering = false;
                this.buffer.clear();
                return false;
            }
        } else if (this.buffering) {
            this.buffer.add(this.bufferEvent());
            return false;
        }
        return true;
    }

    protected abstract void process(List<BufferingParser.Event> var1);
}

