/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.mvndaemon.mvnd.common.Environment;

public class MavenDaemon {
    public static void main(String[] args) throws Exception {
        Path mvndHome = Environment.MVND_HOME.asPath();
        URL[] classpath = (URL[])Stream.concat(Stream.of("lib/ext", "lib", "boot").map(mvndHome::resolve).flatMap(p -> {
            try {
                return Files.list(p);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not list " + p, e);
            }
        }).filter(p -> {
            String fileName = p.getFileName().toString();
            return fileName.endsWith(".jar") && !fileName.startsWith("mvnd-client-");
        }).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])), Stream.of(mvndHome.resolve("conf"), mvndHome.resolve("conf/logging"))).map(Path::normalize).map(Path::toUri).map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new);
        URLClassLoader loader = new URLClassLoader(classpath, null){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                try {
                    return super.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    return MavenDaemon.class.getClassLoader().loadClass(name);
                }
            }

            @Override
            public URL getResource(String name) {
                URL url = super.getResource(name);
                if (url == null) {
                    url = MavenDaemon.class.getClassLoader().getResource(name);
                }
                return url;
            }
        };
        Thread.currentThread().setContextClassLoader(loader);
        Class<?> clazz = loader.loadClass("org.mvndaemon.mvnd.daemon.Server");
        try (AutoCloseable server = (AutoCloseable)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);){
            ((Runnable)((Object)server)).run();
        }
    }
}

