/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.model.InputSource;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.xml.ModelXmlFactory;
import org.apache.maven.api.services.xml.XmlReaderException;
import org.apache.maven.api.services.xml.XmlReaderRequest;
import org.apache.maven.api.services.xml.XmlWriterException;
import org.apache.maven.api.services.xml.XmlWriterRequest;
import org.apache.maven.internal.impl.Utils;
import org.apache.maven.model.v4.MavenXpp3ReaderEx;
import org.apache.maven.model.v4.MavenXpp3WriterEx;
import org.codehaus.plexus.util.ReaderFactory;

@Named
@Singleton
public class DefaultModelXmlFactory
implements ModelXmlFactory {
    public Model read(@Nonnull XmlReaderRequest request) throws XmlReaderException {
        Utils.nonNull(request, "request can not be null");
        Path path = request.getPath();
        URL url = request.getURL();
        Reader reader = request.getReader();
        InputStream inputStream = request.getInputStream();
        if (path == null && url == null && reader == null && inputStream == null) {
            throw new IllegalArgumentException("path, url, reader or inputStream must be non null");
        }
        try {
            InputSource source = null;
            if (request.getModelId() != null || request.getLocation() != null) {
                source = new InputSource(request.getModelId(), request.getLocation());
            }
            MavenXpp3ReaderEx xml = new MavenXpp3ReaderEx();
            xml.setAddDefaultEntities(request.isAddDefaultEntities());
            if (path != null) {
                reader = ReaderFactory.newXmlReader((File)path.toFile());
            } else if (url != null) {
                reader = ReaderFactory.newXmlReader((URL)url);
            } else if (inputStream != null) {
                reader = ReaderFactory.newXmlReader((InputStream)inputStream);
            }
            return xml.read(reader, request.isStrict(), source);
        }
        catch (Exception e) {
            throw new XmlReaderException("Unable to read model", e);
        }
    }

    public void write(XmlWriterRequest<Model> request) throws XmlWriterException {
        block11: {
            Utils.nonNull(request, "request can not be null");
            Model content = Utils.nonNull((Model)request.getContent(), "content can not be null");
            Path path = request.getPath();
            OutputStream outputStream = request.getOutputStream();
            Writer writer = request.getWriter();
            if (writer == null && outputStream == null && path == null) {
                throw new IllegalArgumentException("writer, outputStream or path must be non null");
            }
            try {
                if (writer != null) {
                    new MavenXpp3WriterEx().write(writer, content);
                    break block11;
                }
                if (outputStream != null) {
                    new MavenXpp3WriterEx().write(outputStream, content);
                    break block11;
                }
                try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                    new MavenXpp3WriterEx().write(outputStream, content);
                }
            }
            catch (Exception e) {
                throw new XmlWriterException("Unable to write model", e);
            }
        }
    }

    public static Model fromXml(@Nonnull String xml) throws XmlReaderException {
        return (Model)new DefaultModelXmlFactory().fromXmlString(xml);
    }

    public static String toXml(@Nonnull Model content) throws XmlWriterException {
        return new DefaultModelXmlFactory().toXmlString(content);
    }
}

