/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.Collection;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.Exclusion;
import org.apache.maven.api.Scope;
import org.apache.maven.api.Type;
import org.apache.maven.api.VersionRange;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.TypeRegistry;
import org.apache.maven.internal.impl.AbstractSession;
import org.apache.maven.internal.impl.MappedCollection;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.graph.Dependency;

public class DefaultDependencyCoordinate
implements DependencyCoordinate {
    private final AbstractSession session;
    private final Dependency dependency;

    public DefaultDependencyCoordinate(@Nonnull AbstractSession session, @Nonnull Dependency dependency) {
        this.session = Utils.nonNull(session, "session");
        this.dependency = Utils.nonNull(dependency, "dependency");
    }

    @Nonnull
    public Dependency getDependency() {
        return this.dependency;
    }

    public String getGroupId() {
        return this.dependency.getArtifact().getGroupId();
    }

    public String getArtifactId() {
        return this.dependency.getArtifact().getArtifactId();
    }

    public String getClassifier() {
        return this.dependency.getArtifact().getClassifier();
    }

    public VersionRange getVersion() {
        return this.session.parseVersionRange(this.dependency.getArtifact().getVersion());
    }

    public String getExtension() {
        return this.dependency.getArtifact().getExtension();
    }

    public Type getType() {
        String type = this.dependency.getArtifact().getProperty("type", this.dependency.getArtifact().getExtension());
        return ((TypeRegistry)this.session.getService(TypeRegistry.class)).getType(type);
    }

    @Nonnull
    public Scope getScope() {
        return Scope.get((String)this.dependency.getScope());
    }

    @Nullable
    public Boolean getOptional() {
        return this.dependency.getOptional();
    }

    @Nonnull
    public Collection<Exclusion> getExclusions() {
        return new MappedCollection<Exclusion, org.eclipse.aether.graph.Exclusion>(this.dependency.getExclusions(), this::toExclusion);
    }

    private Exclusion toExclusion(final org.eclipse.aether.graph.Exclusion exclusion) {
        return new Exclusion(){

            @Nullable
            public String getGroupId() {
                return exclusion.getGroupId();
            }

            @Nullable
            public String getArtifactId() {
                return exclusion.getArtifactId();
            }
        };
    }
}

