/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.internal.transformation.ConsumerPomArtifactTransformer;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallResult;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.internal.impl.DefaultInstaller;
import org.eclipse.sisu.Priority;

@Singleton
@Named
@Priority(value=100)
final class MavenInstaller
implements Installer {
    private final DefaultInstaller installer;
    private final ConsumerPomArtifactTransformer consumerPomArtifactTransformer;

    @Inject
    MavenInstaller(DefaultInstaller installer, ConsumerPomArtifactTransformer consumerPomArtifactTransformer) {
        this.installer = Objects.requireNonNull(installer);
        this.consumerPomArtifactTransformer = Objects.requireNonNull(consumerPomArtifactTransformer);
    }

    public InstallResult install(RepositorySystemSession session, InstallRequest request) throws InstallationException {
        return this.installer.install(session, this.consumerPomArtifactTransformer.remapInstallArtifacts(session, request));
    }
}

