/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.xml.XmlNode;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Server
extends IdentifiableBase
implements Serializable {
    final String username;
    final String password;
    final String privateKey;
    final String passphrase;
    final String filePermissions;
    final String directoryPermissions;
    final XmlNode configuration;

    Server(String id, String username, String password, String privateKey, String passphrase, String filePermissions, String directoryPermissions, XmlNode configuration) {
        super(id);
        this.username = username;
        this.password = password;
        this.privateKey = privateKey;
        this.passphrase = passphrase;
        this.filePermissions = filePermissions;
        this.directoryPermissions = directoryPermissions;
        this.configuration = configuration;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public String getFilePermissions() {
        return this.filePermissions;
    }

    public String getDirectoryPermissions() {
        return this.directoryPermissions;
    }

    public XmlNode getConfiguration() {
        return this.configuration;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Server.newBuilder(this);
    }

    @Override
    @Nonnull
    public Server withId(String id) {
        return this.with().id(id).build();
    }

    @Nonnull
    public Server withUsername(String username) {
        return this.with().username(username).build();
    }

    @Nonnull
    public Server withPassword(String password) {
        return this.with().password(password).build();
    }

    @Nonnull
    public Server withPrivateKey(String privateKey) {
        return this.with().privateKey(privateKey).build();
    }

    @Nonnull
    public Server withPassphrase(String passphrase) {
        return this.with().passphrase(passphrase).build();
    }

    @Nonnull
    public Server withFilePermissions(String filePermissions) {
        return this.with().filePermissions(filePermissions).build();
    }

    @Nonnull
    public Server withDirectoryPermissions(String directoryPermissions) {
        return this.with().directoryPermissions(directoryPermissions).build();
    }

    @Nonnull
    public Server withConfiguration(XmlNode configuration) {
        return this.with().configuration(configuration).build();
    }

    @Nonnull
    public static Server newInstance() {
        return Server.newInstance(true);
    }

    @Nonnull
    public static Server newInstance(boolean withDefaults) {
        return Server.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Server.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Server from) {
        return Server.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Server from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends IdentifiableBase.Builder {
        Server base;
        String username;
        String password;
        String privateKey;
        String passphrase;
        String filePermissions;
        String directoryPermissions;
        XmlNode configuration;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Server base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.username = base.username;
                this.password = base.password;
                this.privateKey = base.privateKey;
                this.passphrase = base.passphrase;
                this.filePermissions = base.filePermissions;
                this.directoryPermissions = base.directoryPermissions;
                this.configuration = base.configuration;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder username(String username) {
            this.username = username;
            return this;
        }

        @Nonnull
        public Builder password(String password) {
            this.password = password;
            return this;
        }

        @Nonnull
        public Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Nonnull
        public Builder passphrase(String passphrase) {
            this.passphrase = passphrase;
            return this;
        }

        @Nonnull
        public Builder filePermissions(String filePermissions) {
            this.filePermissions = filePermissions;
            return this;
        }

        @Nonnull
        public Builder directoryPermissions(String directoryPermissions) {
            this.directoryPermissions = directoryPermissions;
            return this;
        }

        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        @Nonnull
        public Server build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.username != null && this.username != this.base.username || this.password != null && this.password != this.base.password || this.privateKey != null && this.privateKey != this.base.privateKey || this.passphrase != null && this.passphrase != this.base.passphrase || this.filePermissions != null && this.filePermissions != this.base.filePermissions || this.directoryPermissions != null && this.directoryPermissions != this.base.directoryPermissions || this.configuration != null && this.configuration != this.base.configuration)) {
                return this.base;
            }
            return new Server(this.id != null ? this.id : (this.base != null ? this.base.id : null), this.username != null ? this.username : (this.base != null ? this.base.username : null), this.password != null ? this.password : (this.base != null ? this.base.password : null), this.privateKey != null ? this.privateKey : (this.base != null ? this.base.privateKey : null), this.passphrase != null ? this.passphrase : (this.base != null ? this.base.passphrase : null), this.filePermissions != null ? this.filePermissions : (this.base != null ? this.base.filePermissions : null), this.directoryPermissions != null ? this.directoryPermissions : (this.base != null ? this.base.directoryPermissions : null), (XmlNode)(this.configuration != null ? this.configuration : (this.base != null ? this.base.configuration : null)));
        }
    }
}

