/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.Contributor;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Developer
extends Contributor
implements Serializable,
InputLocationTracker {
    final String id;
    final InputLocation idLocation;

    Developer(String name, String email, String url, String organization, String organizationUrl, Collection<String> roles, String timezone, Map<String, String> properties, String id, Map<Object, InputLocation> locations, InputLocation location, InputLocation nameLocation, InputLocation emailLocation, InputLocation urlLocation, InputLocation organizationLocation, InputLocation organizationUrlLocation, InputLocation rolesLocation, InputLocation timezoneLocation, InputLocation propertiesLocation, InputLocation idLocation) {
        super(name, email, url, organization, organizationUrl, roles, timezone, properties, locations, location, nameLocation, emailLocation, urlLocation, organizationLocation, organizationUrlLocation, rolesLocation, timezoneLocation, propertiesLocation);
        this.id = id;
        this.idLocation = idLocation;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "id": {
                    return this.idLocation;
                }
            }
        }
        return super.getLocation(key);
    }

    @Override
    @Nonnull
    public Builder with() {
        return Developer.newBuilder(this);
    }

    @Override
    @Nonnull
    public Developer withName(String name) {
        return this.with().name(name).build();
    }

    @Override
    @Nonnull
    public Developer withEmail(String email) {
        return this.with().email(email).build();
    }

    @Override
    @Nonnull
    public Developer withUrl(String url) {
        return this.with().url(url).build();
    }

    @Override
    @Nonnull
    public Developer withOrganization(String organization) {
        return this.with().organization(organization).build();
    }

    @Override
    @Nonnull
    public Developer withOrganizationUrl(String organizationUrl) {
        return this.with().organizationUrl(organizationUrl).build();
    }

    @Override
    @Nonnull
    public Developer withRoles(Collection<String> roles) {
        return ((Builder)this.with().roles((Collection)roles)).build();
    }

    @Override
    @Nonnull
    public Developer withTimezone(String timezone) {
        return this.with().timezone(timezone).build();
    }

    @Override
    @Nonnull
    public Developer withProperties(Map<String, String> properties) {
        return ((Builder)this.with().properties((Map)properties)).build();
    }

    @Nonnull
    public Developer withId(String id) {
        return this.with().id(id).build();
    }

    @Nonnull
    public static Developer newInstance() {
        return Developer.newInstance(true);
    }

    @Nonnull
    public static Developer newInstance(boolean withDefaults) {
        return Developer.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Developer.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Developer from) {
        return Developer.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Developer from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @Override
    public String toString() {
        return "Developer {id=" + this.getId() + ", " + super.toString() + "}";
    }

    @NotThreadSafe
    public static class Builder
    extends Contributor.Builder {
        Developer base;
        String id;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Developer base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.id = base.id;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @Nonnull
        public Builder email(String email) {
            this.email = email;
            return this;
        }

        @Override
        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        @Nonnull
        public Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        @Override
        @Nonnull
        public Builder organizationUrl(String organizationUrl) {
            this.organizationUrl = organizationUrl;
            return this;
        }

        @Override
        @Nonnull
        public Builder roles(Collection<String> roles) {
            this.roles = roles;
            return this;
        }

        @Override
        @Nonnull
        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Override
        @Nonnull
        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Developer build() {
            if (!(this.base == null || this.name != null && this.name != this.base.name || this.email != null && this.email != this.base.email || this.url != null && this.url != this.base.url || this.organization != null && this.organization != this.base.organization || this.organizationUrl != null && this.organizationUrl != this.base.organizationUrl || this.roles != null && this.roles != this.base.roles || this.timezone != null && this.timezone != this.base.timezone || this.properties != null && this.properties != this.base.properties || this.id != null && this.id != this.base.id)) {
                return this.base;
            }
            Map locations = null;
            InputLocation location = null;
            InputLocation nameLocation = null;
            InputLocation emailLocation = null;
            InputLocation urlLocation = null;
            InputLocation organizationLocation = null;
            InputLocation organizationUrlLocation = null;
            InputLocation rolesLocation = null;
            InputLocation timezoneLocation = null;
            InputLocation propertiesLocation = null;
            InputLocation idLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = (InputLocation)locations.remove("");
                nameLocation = (InputLocation)locations.remove("name");
                emailLocation = (InputLocation)locations.remove("email");
                urlLocation = (InputLocation)locations.remove("url");
                organizationLocation = (InputLocation)locations.remove("organization");
                organizationUrlLocation = (InputLocation)locations.remove("organizationUrl");
                rolesLocation = (InputLocation)locations.remove("roles");
                timezoneLocation = (InputLocation)locations.remove("timezone");
                propertiesLocation = (InputLocation)locations.remove("properties");
                idLocation = (InputLocation)locations.remove("id");
            }
            return new Developer(this.name != null ? this.name : (this.base != null ? this.base.name : null), this.email != null ? this.email : (this.base != null ? this.base.email : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), this.organization != null ? this.organization : (this.base != null ? this.base.organization : null), this.organizationUrl != null ? this.organizationUrl : (this.base != null ? this.base.organizationUrl : null), this.roles != null ? this.roles : (this.base != null ? this.base.roles : null), this.timezone != null ? this.timezone : (this.base != null ? this.base.timezone : null), this.properties != null ? this.properties : (this.base != null ? this.base.properties : null), this.id != null ? this.id : (this.base != null ? this.base.id : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), nameLocation != null ? nameLocation : (this.base != null ? this.base.nameLocation : null), emailLocation != null ? emailLocation : (this.base != null ? this.base.emailLocation : null), urlLocation != null ? urlLocation : (this.base != null ? this.base.urlLocation : null), organizationLocation != null ? organizationLocation : (this.base != null ? this.base.organizationLocation : null), organizationUrlLocation != null ? organizationUrlLocation : (this.base != null ? this.base.organizationUrlLocation : null), rolesLocation != null ? rolesLocation : (this.base != null ? this.base.rolesLocation : null), timezoneLocation != null ? timezoneLocation : (this.base != null ? this.base.timezoneLocation : null), propertiesLocation != null ? propertiesLocation : (this.base != null ? this.base.propertiesLocation : null), idLocation != null ? idLocation : (this.base != null ? this.base.idLocation : null));
        }
    }
}

