/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.project.SnapshotModelCache;
import org.apache.maven.repository.internal.DefaultModelCacheFactory;
import org.apache.maven.repository.internal.ModelCacheFactory;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.sisu.Priority;

@Singleton
@Named
@Priority(value=10)
public class SnapshotModelCacheFactory
implements ModelCacheFactory {
    private final ModelCacheFactory factory;
    private final ModelCache globalCache;

    @Inject
    public SnapshotModelCacheFactory(DefaultModelCacheFactory factory) {
        this.factory = factory;
        this.globalCache = factory.createCache((RepositorySystemSession)new DefaultRepositorySystemSession());
    }

    public ModelCache createCache(RepositorySystemSession session) {
        return new SnapshotModelCache(this.globalCache, this.factory.createCache(session));
    }
}

