/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.ActivationProperty;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.model.RepositoryPolicy;
import org.apache.maven.api.settings.Activation;
import org.apache.maven.api.settings.ActivationFile;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.Profile;
import org.apache.maven.api.settings.Repository;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.v4.SettingsMerger;

public final class SettingsUtilsV4 {
    private SettingsUtilsV4() {
    }

    public static org.apache.maven.api.settings.Settings merge(org.apache.maven.api.settings.Settings dominant, org.apache.maven.api.settings.Settings recessive) {
        return new SettingsMerger().merge(dominant, recessive, true, Collections.emptyMap());
    }

    public static Profile convertToSettingsProfile(org.apache.maven.api.model.Profile modelProfile) {
        List pluginRepos;
        Profile.Builder profile = Profile.newBuilder();
        profile.id(modelProfile.getId());
        Activation modelActivation = modelProfile.getActivation();
        if (modelActivation != null) {
            org.apache.maven.api.model.ActivationFile modelFile;
            Object modelOs;
            Activation.Builder activation = org.apache.maven.api.settings.Activation.newBuilder();
            activation.activeByDefault(modelActivation.isActiveByDefault());
            activation.jdk(modelActivation.getJdk());
            ActivationProperty modelProp = modelActivation.getProperty();
            if (modelProp != null) {
                org.apache.maven.api.settings.ActivationProperty prop = org.apache.maven.api.settings.ActivationProperty.newBuilder().name(modelProp.getName()).value(modelProp.getValue()).build();
                activation.property(prop);
            }
            if ((modelOs = modelActivation.getOs()) != null) {
                ActivationOS os = ActivationOS.newBuilder().arch(modelOs.getArch()).family(modelOs.getFamily()).name(modelOs.getName()).version(modelOs.getVersion()).build();
                activation.os(os);
            }
            if ((modelFile = modelActivation.getFile()) != null) {
                ActivationFile file = ActivationFile.newBuilder().exists(modelFile.getExists()).missing(modelFile.getMissing()).build();
                activation.file(file);
            }
            profile.activation(activation.build());
        }
        profile.properties(modelProfile.getProperties().entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toString(), e -> ((String)e.getValue()).toString())));
        List repos = modelProfile.getRepositories();
        if (repos != null) {
            ArrayList<Repository> repositories = new ArrayList<Repository>();
            for (org.apache.maven.api.model.Repository repo : repos) {
                repositories.add(SettingsUtilsV4.convertToSettingsRepository(repo));
            }
            profile.repositories(repositories);
        }
        if ((pluginRepos = modelProfile.getPluginRepositories()) != null) {
            ArrayList<Repository> repositories = new ArrayList<Repository>();
            for (org.apache.maven.api.model.Repository pluginRepo : pluginRepos) {
                repositories.add(SettingsUtilsV4.convertToSettingsRepository(pluginRepo));
            }
            profile.pluginRepositories(repositories);
        }
        return profile.build();
    }

    public static org.apache.maven.api.model.Profile convertFromSettingsProfile(Profile settingsProfile) {
        List pluginRepos;
        Profile.Builder profile = org.apache.maven.api.model.Profile.newBuilder();
        profile.id(settingsProfile.getId());
        org.apache.maven.api.settings.Activation settingsActivation = settingsProfile.getActivation();
        if (settingsActivation != null) {
            ActivationFile settingsFile;
            ActivationOS settingsOs;
            Activation.Builder activation = Activation.newBuilder();
            activation.activeByDefault(settingsActivation.isActiveByDefault());
            activation.jdk(settingsActivation.getJdk());
            org.apache.maven.api.settings.ActivationProperty settingsProp = settingsActivation.getProperty();
            if (settingsProp != null) {
                activation.property(ActivationProperty.newBuilder().name(settingsProp.getName()).value(settingsProp.getValue()).build());
            }
            if ((settingsOs = settingsActivation.getOs()) != null) {
                activation.os(org.apache.maven.api.model.ActivationOS.newBuilder().arch(settingsOs.getArch()).family(settingsOs.getFamily()).name(settingsOs.getName()).version(settingsOs.getVersion()).build());
            }
            if ((settingsFile = settingsActivation.getFile()) != null) {
                activation.file(org.apache.maven.api.model.ActivationFile.newBuilder().exists(settingsFile.getExists()).missing(settingsFile.getMissing()).build());
            }
            profile.activation(activation.build());
        }
        profile.properties(settingsProfile.getProperties());
        List repos = settingsProfile.getRepositories();
        if (repos != null) {
            profile.repositories((Collection)repos.stream().map(SettingsUtilsV4::convertFromSettingsRepository).collect(Collectors.toList()));
        }
        if ((pluginRepos = settingsProfile.getPluginRepositories()) != null) {
            profile.pluginRepositories((Collection)pluginRepos.stream().map(SettingsUtilsV4::convertFromSettingsRepository).collect(Collectors.toList()));
        }
        org.apache.maven.api.model.Profile value = profile.build();
        value.setSource("settings.xml");
        return value;
    }

    private static org.apache.maven.api.model.Repository convertFromSettingsRepository(Repository settingsRepo) {
        Repository.Builder repo = org.apache.maven.api.model.Repository.newBuilder();
        repo.id(settingsRepo.getId());
        repo.layout(settingsRepo.getLayout());
        repo.name(settingsRepo.getName());
        repo.url(settingsRepo.getUrl());
        if (settingsRepo.getSnapshots() != null) {
            repo.snapshots(SettingsUtilsV4.convertRepositoryPolicy(settingsRepo.getSnapshots()));
        }
        if (settingsRepo.getReleases() != null) {
            repo.releases(SettingsUtilsV4.convertRepositoryPolicy(settingsRepo.getReleases()));
        }
        return repo.build();
    }

    private static RepositoryPolicy convertRepositoryPolicy(org.apache.maven.api.settings.RepositoryPolicy settingsPolicy) {
        RepositoryPolicy policy = RepositoryPolicy.newBuilder().enabled(Boolean.toString(settingsPolicy.isEnabled())).updatePolicy(settingsPolicy.getUpdatePolicy()).checksumPolicy(settingsPolicy.getChecksumPolicy()).build();
        return policy;
    }

    private static Repository convertToSettingsRepository(org.apache.maven.api.model.Repository modelRepo) {
        Repository repo = Repository.newBuilder().id(modelRepo.getId()).layout(modelRepo.getLayout()).name(modelRepo.getName()).url(modelRepo.getUrl()).snapshots(modelRepo.getSnapshots() != null ? SettingsUtilsV4.convertRepositoryPolicy(modelRepo.getSnapshots()) : null).releases(modelRepo.getReleases() != null ? SettingsUtilsV4.convertRepositoryPolicy(modelRepo.getReleases()) : null).build();
        return repo;
    }

    private static org.apache.maven.api.settings.RepositoryPolicy convertRepositoryPolicy(RepositoryPolicy modelPolicy) {
        org.apache.maven.api.settings.RepositoryPolicy policy = org.apache.maven.api.settings.RepositoryPolicy.newBuilder().enabled(modelPolicy.isEnabled()).updatePolicy(modelPolicy.getUpdatePolicy()).checksumPolicy(modelPolicy.getUpdatePolicy()).build();
        return policy;
    }

    public static Settings copySettings(Settings settings) {
        if (settings == null) {
            return null;
        }
        return new Settings(settings.getDelegate());
    }
}

