/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.api.model.Build;
import org.apache.maven.api.model.Dependency;
import org.apache.maven.api.model.Extension;
import org.apache.maven.api.model.Parent;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.DuplicateProjectException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;
import org.codehaus.plexus.util.dag.Vertex;

public class ProjectSorter {
    private DAG dag = new DAG();
    private List<MavenProject> sortedProjects;
    private Map<String, MavenProject> projectMap;

    public ProjectSorter(Collection<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException {
        String projectId;
        this.projectMap = new HashMap<String, MavenProject>(projects.size() * 2);
        HashMap<String, Map<String, Vertex>> vertexMap = new HashMap<String, Map<String, Vertex>>(projects.size() * 2);
        for (MavenProject project : projects) {
            projectId = ProjectSorter.getId(project);
            MavenProject conflictingProject = this.projectMap.put(projectId, project);
            if (conflictingProject != null) {
                throw new DuplicateProjectException(projectId, conflictingProject.getFile(), project.getFile(), "Project '" + projectId + "' is duplicated in the reactor");
            }
            String projectKey = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            Map vertices = vertexMap.computeIfAbsent(projectKey, k -> new HashMap(2, 1.0f));
            vertices.put(project.getVersion(), this.dag.addVertex(projectId));
        }
        for (Vertex projectVertex : this.dag.getVertices()) {
            Build build;
            projectId = projectVertex.getLabel();
            MavenProject project = this.projectMap.get(projectId);
            for (Dependency dependency : project.getModel().getDelegate().getDependencies()) {
                this.addEdge(this.projectMap, vertexMap, project, projectVertex, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), false, false);
            }
            Parent parent = project.getModel().getDelegate().getParent();
            if (parent != null) {
                this.addEdge(this.projectMap, vertexMap, null, projectVertex, parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), true, false);
            }
            if ((build = project.getModel().getDelegate().getBuild()) == null) continue;
            for (Plugin plugin : build.getPlugins()) {
                this.addEdge(this.projectMap, vertexMap, project, projectVertex, plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), false, true);
                for (Dependency dependency : plugin.getDependencies()) {
                    this.addEdge(this.projectMap, vertexMap, project, projectVertex, dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), false, true);
                }
            }
            for (Extension extension : build.getExtensions()) {
                this.addEdge(this.projectMap, vertexMap, project, projectVertex, extension.getGroupId(), extension.getArtifactId(), extension.getVersion(), false, true);
            }
        }
        List sortedProjectLabels = TopologicalSorter.sort((DAG)this.dag);
        this.sortedProjects = sortedProjectLabels.stream().map(id -> this.projectMap.get(id)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private void addEdge(Map<String, MavenProject> projectMap, Map<String, Map<String, Vertex>> vertexMap, MavenProject project, Vertex projectVertex, String groupId, String artifactId, String version, boolean force, boolean safe) throws CycleDetectedException {
        String projectKey = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
        Map<String, Vertex> vertices = vertexMap.get(projectKey);
        if (vertices != null) {
            if (this.isSpecificVersion(version)) {
                Vertex vertex = vertices.get(version);
                if (vertex != null) {
                    this.addEdge(projectVertex, vertex, project, projectMap, force, safe);
                }
            } else {
                for (Vertex vertex : vertices.values()) {
                    this.addEdge(projectVertex, vertex, project, projectMap, force, safe);
                }
            }
        }
    }

    private void addEdge(Vertex fromVertex, Vertex toVertex, MavenProject fromProject, Map<String, MavenProject> projectMap, boolean force, boolean safe) throws CycleDetectedException {
        block5: {
            if (fromVertex.equals(toVertex)) {
                return;
            }
            if (fromProject != null) {
                MavenProject toProject = projectMap.get(toVertex.getLabel());
                fromProject.addProjectReference(toProject);
            }
            if (force && toVertex.getChildren().contains(fromVertex)) {
                this.dag.removeEdge(toVertex, fromVertex);
            }
            try {
                this.dag.addEdge(fromVertex, toVertex);
            }
            catch (CycleDetectedException e) {
                if (safe) break block5;
                throw e;
            }
        }
    }

    private boolean isSpecificVersion(String version) {
        return !StringUtils.isEmpty((String)version) && !version.startsWith("[") && !version.startsWith("(");
    }

    public MavenProject getTopLevelProject() {
        return this.sortedProjects.stream().filter(MavenProject::isExecutionRoot).findFirst().orElse(null);
    }

    public List<MavenProject> getSortedProjects() {
        return this.sortedProjects;
    }

    public boolean hasMultipleProjects() {
        return this.sortedProjects.size() > 1;
    }

    public List<String> getDependents(String id) {
        return this.dag.getParentLabels(id);
    }

    public List<String> getDependencies(String id) {
        return this.dag.getChildLabels(id);
    }

    public static String getId(MavenProject project) {
        return ArtifactUtils.key((String)project.getGroupId(), (String)project.getArtifactId(), (String)project.getVersion());
    }

    public DAG getDAG() {
        return this.dag;
    }

    public Map<String, MavenProject> getProjectMap() {
        return this.projectMap;
    }
}

