/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.codehaus.plexus.util.StringUtils;

public class PluginParameterException
extends PluginConfigurationException {
    private static final String LS = System.lineSeparator();
    private final List<Parameter> parameters;
    private final MojoDescriptor mojo;

    public PluginParameterException(MojoDescriptor mojo, List<Parameter> parameters) {
        super(mojo.getPluginDescriptor(), "The parameters " + PluginParameterException.format(parameters) + " for goal " + mojo.getRoleHint() + " are missing or invalid");
        this.mojo = mojo;
        this.parameters = parameters;
    }

    private static String format(List<Parameter> parameters) {
        StringBuilder buffer = new StringBuilder(128);
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'').append(parameter.getName()).append('\'');
            }
        }
        return buffer.toString();
    }

    public MojoDescriptor getMojoDescriptor() {
        return this.mojo;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    private static void decomposeParameterIntoUserInstructions(MojoDescriptor mojo, Parameter param, StringBuilder messageBuffer) {
        String expression = param.getExpression();
        if (param.isEditable()) {
            boolean isArray = param.getType().endsWith("[]");
            boolean isCollection = false;
            boolean isMap = false;
            boolean isProperties = false;
            if (!isArray) {
                try {
                    isCollection = Collection.class.isAssignableFrom(Class.forName(param.getType()));
                    isMap = Map.class.isAssignableFrom(Class.forName(param.getType()));
                    isProperties = Properties.class.isAssignableFrom(Class.forName(param.getType()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            messageBuffer.append("Inside the definition for plugin '");
            messageBuffer.append(mojo.getPluginDescriptor().getArtifactId());
            messageBuffer.append("', specify the following:").append(LS).append(LS);
            messageBuffer.append("<configuration>").append(LS).append("  ...").append(LS);
            messageBuffer.append("  <").append(param.getName()).append('>');
            if (isArray || isCollection) {
                messageBuffer.append(LS);
                messageBuffer.append("    <item>");
            } else if (isProperties) {
                messageBuffer.append(LS);
                messageBuffer.append("    <property>").append(LS);
                messageBuffer.append("      <name>KEY</name>").append(LS);
                messageBuffer.append("      <value>");
            } else if (isMap) {
                messageBuffer.append(LS);
                messageBuffer.append("    <KEY>");
            }
            messageBuffer.append("VALUE");
            if (isArray || isCollection) {
                messageBuffer.append("</item>").append(LS);
                messageBuffer.append("  ");
            } else if (isProperties) {
                messageBuffer.append("</value>").append(LS);
                messageBuffer.append("    </property>").append(LS);
                messageBuffer.append("  ");
            } else if (isMap) {
                messageBuffer.append("</KEY>").append(LS);
                messageBuffer.append("  ");
            }
            messageBuffer.append("</").append(param.getName()).append(">").append(LS);
            messageBuffer.append("</configuration>");
            String alias = param.getAlias();
            if (StringUtils.isNotEmpty((String)alias) && !alias.equals(param.getName())) {
                messageBuffer.append(LS).append(LS).append("-OR-").append(LS).append(LS);
                messageBuffer.append("<configuration>").append(LS).append("  ...").append(LS);
                messageBuffer.append("  <").append(alias).append(">VALUE</").append(alias).append(">").append(LS).append("</configuration>").append(LS);
            }
        }
        if (StringUtils.isEmpty((String)expression)) {
            messageBuffer.append('.');
        } else if (param.isEditable()) {
            messageBuffer.append(LS).append(LS).append("-OR-").append(LS).append(LS);
        }
    }

    public String buildDiagnosticMessage() {
        StringBuilder messageBuffer = new StringBuilder(256);
        List<Parameter> params = this.getParameters();
        MojoDescriptor mojo = this.getMojoDescriptor();
        messageBuffer.append("One or more required plugin parameters are invalid/missing for '").append(mojo.getPluginDescriptor().getGoalPrefix()).append(':').append(mojo.getGoal()).append("'").append(LS);
        int idx = 0;
        for (Parameter param : params) {
            messageBuffer.append(LS).append("[").append(idx).append("] ");
            PluginParameterException.decomposeParameterIntoUserInstructions(mojo, param, messageBuffer);
            messageBuffer.append(LS);
            ++idx;
        }
        return messageBuffer.toString();
    }
}

