/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.internal.xml.XmlNodeImpl;
import org.apache.maven.lifecycle.internal.LifecyclePluginResolver;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.prefix.DefaultPluginPrefixRequest;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.prefix.PluginPrefixResolver;
import org.apache.maven.plugin.prefix.PluginPrefixResult;
import org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class MojoDescriptorCreator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PluginVersionResolver pluginVersionResolver;
    private final BuildPluginManager pluginManager;
    private final PluginPrefixResolver pluginPrefixResolver;
    private final LifecyclePluginResolver lifecyclePluginResolver;

    @Inject
    public MojoDescriptorCreator(PluginVersionResolver pluginVersionResolver, BuildPluginManager pluginManager, PluginPrefixResolver pluginPrefixResolver, LifecyclePluginResolver lifecyclePluginResolver) {
        this.pluginVersionResolver = pluginVersionResolver;
        this.pluginManager = pluginManager;
        this.pluginPrefixResolver = pluginPrefixResolver;
        this.lifecyclePluginResolver = lifecyclePluginResolver;
    }

    private Plugin findPlugin(String groupId, String artifactId, Collection<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (!artifactId.equals(plugin.getArtifactId()) || !groupId.equals(plugin.getGroupId())) continue;
            return plugin;
        }
        return null;
    }

    public static Xpp3Dom convert(MojoDescriptor mojoDescriptor) {
        PlexusConfiguration c = mojoDescriptor.getMojoConfiguration();
        ArrayList<XmlNodeImpl> children = new ArrayList<XmlNodeImpl>();
        PlexusConfiguration[] ces = c.getChildren();
        if (ces != null) {
            for (PlexusConfiguration ce : ces) {
                String value = ce.getValue(null);
                String defaultValue = ce.getAttribute("default-value", null);
                if (value == null && defaultValue == null) continue;
                XmlNodeImpl e = new XmlNodeImpl(ce.getName(), value, defaultValue != null ? Collections.singletonMap("default-value", defaultValue) : null, null, null);
                children.add(e);
            }
        }
        XmlNodeImpl dom = new XmlNodeImpl("configuration", null, null, children, null);
        return new Xpp3Dom((XmlNode)dom);
    }

    public MojoDescriptor getMojoDescriptor(String task, MavenSession session, MavenProject project) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException {
        int executionIdx;
        String goal = null;
        Plugin plugin = null;
        StringTokenizer tok = new StringTokenizer(task, ":");
        int numTokens = tok.countTokens();
        if (numTokens >= 4) {
            plugin = new Plugin();
            plugin.setGroupId(tok.nextToken());
            plugin.setArtifactId(tok.nextToken());
            plugin.setVersion(tok.nextToken());
            goal = tok.nextToken();
            while (tok.hasMoreTokens()) {
                goal = goal + ":" + tok.nextToken();
            }
        } else if (numTokens == 3) {
            String firstToken = tok.nextToken();
            if (firstToken.contains(".")) {
                plugin = new Plugin();
                plugin.setGroupId(firstToken);
                plugin.setArtifactId(tok.nextToken());
            } else {
                plugin = this.findPluginForPrefix(firstToken, session);
                plugin.setVersion(tok.nextToken());
            }
            goal = tok.nextToken();
        } else {
            String prefix = tok.nextToken();
            goal = numTokens == 2 ? tok.nextToken() : "";
            plugin = this.findPluginForPrefix(prefix, session);
        }
        if ((executionIdx = goal.indexOf(64)) > 0) {
            goal = goal.substring(0, executionIdx);
        }
        this.injectPluginDeclarationFromProject(plugin, project);
        if (plugin.getVersion() == null) {
            this.resolvePluginVersion(plugin, session, project);
        }
        return this.pluginManager.getMojoDescriptor(plugin, goal.toString(), project.getRemotePluginRepositories(), session.getRepositorySession());
    }

    public Plugin findPluginForPrefix(String prefix, MavenSession session) throws NoPluginFoundForPrefixException {
        if (session.getCurrentProject() != null) {
            try {
                this.lifecyclePluginResolver.resolveMissingPluginVersions(session.getCurrentProject(), session);
            }
            catch (PluginVersionResolutionException e) {
                this.logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        DefaultPluginPrefixRequest prefixRequest = new DefaultPluginPrefixRequest(prefix, session);
        PluginPrefixResult prefixResult = this.pluginPrefixResolver.resolve(prefixRequest);
        Plugin plugin = new Plugin();
        plugin.setGroupId(prefixResult.getGroupId());
        plugin.setArtifactId(prefixResult.getArtifactId());
        return plugin;
    }

    private void resolvePluginVersion(Plugin plugin, MavenSession session, MavenProject project) throws PluginVersionResolutionException {
        DefaultPluginVersionRequest versionRequest = new DefaultPluginVersionRequest(plugin, session.getRepositorySession(), project.getRemotePluginRepositories());
        plugin.setVersion(this.pluginVersionResolver.resolve(versionRequest).getVersion());
    }

    private void injectPluginDeclarationFromProject(Plugin plugin, MavenProject project) {
        Plugin pluginInPom = this.findPlugin(plugin, project.getBuildPlugins());
        if (pluginInPom == null && project.getPluginManagement() != null) {
            pluginInPom = this.findPlugin(plugin, project.getPluginManagement().getPlugins());
        }
        if (pluginInPom != null) {
            if (plugin.getVersion() == null) {
                plugin.setVersion(pluginInPom.getVersion());
            }
            plugin.setDependencies(new ArrayList(pluginInPom.getDependencies()));
        }
    }

    private Plugin findPlugin(Plugin plugin, Collection<Plugin> plugins) {
        return this.findPlugin(plugin.getGroupId(), plugin.getArtifactId(), plugins);
    }
}

