/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.Objects;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.Version;
import org.apache.maven.api.VersionRange;
import org.apache.maven.api.services.VersionParser;
import org.apache.maven.api.services.VersionParserException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.internal.impl.Utils;

@Named
@Singleton
public class DefaultVersionParser
implements VersionParser {
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final Pattern SNAPSHOT_TIMESTAMP = Pattern.compile("^(.*-)?([0-9]{8}\\.[0-9]{6}-[0-9]+)$");

    public Version parseVersion(String version) {
        return new DefaultVersion((ArtifactVersion)new DefaultArtifactVersion(Utils.nonNull(version, "version")));
    }

    public VersionRange parseVersionRange(String range) {
        try {
            return new DefaultVersionRange(org.apache.maven.artifact.versioning.VersionRange.createFromVersionSpec((String)Utils.nonNull(range, "version")));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new VersionParserException("Unable to parse version range: " + range, (Exception)((Object)e));
        }
    }

    public boolean isSnapshot(String version) {
        return DefaultVersionParser.checkSnapshot(version);
    }

    static boolean checkSnapshot(String version) {
        return version.endsWith(SNAPSHOT) || SNAPSHOT_TIMESTAMP.matcher(version).matches();
    }

    static class DefaultVersion
    implements Version {
        private final ArtifactVersion delegate;

        DefaultVersion(ArtifactVersion delegate) {
            this.delegate = delegate;
        }

        public int compareTo(Version o) {
            if (o instanceof DefaultVersion) {
                return this.delegate.compareTo((Object)((DefaultVersion)o).delegate);
            }
            return this.delegate.compareTo((Object)new DefaultArtifactVersion(o.toString()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultVersion that = (DefaultVersion)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.delegate);
        }

        public String asString() {
            return this.delegate.toString();
        }

        public String toString() {
            return this.asString();
        }
    }

    static class DefaultVersionRange
    implements VersionRange {
        private final org.apache.maven.artifact.versioning.VersionRange delegate;

        DefaultVersionRange(org.apache.maven.artifact.versioning.VersionRange delegate) {
            this.delegate = delegate;
        }

        public boolean contains(Version version) {
            if (version instanceof DefaultVersion) {
                return this.delegate.containsVersion(((DefaultVersion)version).delegate);
            }
            return this.delegate.containsVersion((ArtifactVersion)new DefaultArtifactVersion(version.toString()));
        }

        public String asString() {
            return this.delegate.toString();
        }

        public String toString() {
            return this.asString();
        }
    }
}

