/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.Node;
import org.apache.maven.api.Project;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.DependencyCollectorResult;
import org.apache.maven.api.services.ProjectBuilderException;
import org.apache.maven.api.services.ProjectBuilderRequest;
import org.apache.maven.api.services.ProjectBuilderResult;
import org.apache.maven.api.services.Source;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.internal.impl.DefaultSession;
import org.apache.maven.internal.impl.MappedCollection;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.eclipse.aether.artifact.Artifact;

@Named
@Singleton
public class DefaultProjectBuilder
implements org.apache.maven.api.services.ProjectBuilder {
    private final ProjectBuilder builder;

    @Inject
    public DefaultProjectBuilder(ProjectBuilder builder) {
        this.builder = builder;
    }

    @Nonnull
    public ProjectBuilderResult build(ProjectBuilderRequest request) throws ProjectBuilderException, IllegalArgumentException {
        final DefaultSession session = (DefaultSession)request.getSession();
        try {
            ProjectBuildingResult res;
            List<ArtifactRepository> repositories = session.toArtifactRepositories(session.getRemoteRepositories());
            ProjectBuildingRequest req = new DefaultProjectBuildingRequest().setRepositorySession(session.getSession()).setRemoteRepositories(repositories).setPluginArtifactRepositories(repositories).setProcessPlugins(request.isProcessPlugins());
            if (request.getPath().isPresent()) {
                Path path = (Path)request.getPath().get();
                res = this.builder.build(path.toFile(), req);
            } else if (request.getSource().isPresent()) {
                final Source source = (Source)request.getSource().get();
                ModelSource modelSource = new ModelSource(){

                    public InputStream getInputStream() throws IOException {
                        return source.getInputStream();
                    }

                    public String getLocation() {
                        return source.getLocation();
                    }
                };
                res = this.builder.build(modelSource, req);
            } else if (request.getArtifact().isPresent()) {
                org.apache.maven.api.Artifact a = (org.apache.maven.api.Artifact)request.getArtifact().get();
                Artifact aetherArtifact = session.toArtifact(a);
                org.apache.maven.artifact.Artifact artifact = RepositoryUtils.toArtifact(aetherArtifact);
                res = this.builder.build(artifact, request.isAllowStubModel(), req);
            } else if (request.getCoordinate().isPresent()) {
                ArtifactCoordinate c = (ArtifactCoordinate)request.getCoordinate().get();
                DefaultArtifact artifact = new DefaultArtifact(c.getGroupId(), c.getArtifactId(), c.getVersion().asString(), null, c.getExtension(), c.getClassifier(), null);
                res = this.builder.build((org.apache.maven.artifact.Artifact)artifact, request.isAllowStubModel(), req);
            } else {
                throw new IllegalArgumentException("Invalid request");
            }
            return new ProjectBuilderResult(){

                @Nonnull
                public String getProjectId() {
                    return res.getProjectId();
                }

                @Nonnull
                public Optional<Path> getPomFile() {
                    return Optional.ofNullable(res.getPomFile()).map(File::toPath);
                }

                @Nonnull
                public Optional<Project> getProject() {
                    return Optional.ofNullable(res.getProject()).map(session::getProject);
                }

                @Nonnull
                public Collection<BuilderProblem> getProblems() {
                    return new MappedCollection<BuilderProblem, ModelProblem>(res.getProblems(), this::toProblem);
                }

                private BuilderProblem toProblem(final ModelProblem problem) {
                    return new BuilderProblem(){

                        public String getSource() {
                            return problem.getSource();
                        }

                        public int getLineNumber() {
                            return problem.getLineNumber();
                        }

                        public int getColumnNumber() {
                            return problem.getColumnNumber();
                        }

                        public String getLocation() {
                            StringBuilder buffer = new StringBuilder(256);
                            if (this.getSource().length() > 0) {
                                if (buffer.length() > 0) {
                                    buffer.append(", ");
                                }
                                buffer.append(this.getSource());
                            }
                            if (this.getLineNumber() > 0) {
                                if (buffer.length() > 0) {
                                    buffer.append(", ");
                                }
                                buffer.append("line ").append(this.getLineNumber());
                            }
                            if (this.getColumnNumber() > 0) {
                                if (buffer.length() > 0) {
                                    buffer.append(", ");
                                }
                                buffer.append("column ").append(this.getColumnNumber());
                            }
                            return buffer.toString();
                        }

                        public Exception getException() {
                            return problem.getException();
                        }

                        public String getMessage() {
                            return problem.getMessage();
                        }

                        public BuilderProblem.Severity getSeverity() {
                            return BuilderProblem.Severity.valueOf((String)problem.getSeverity().name());
                        }
                    };
                }

                @Nonnull
                public Optional<DependencyCollectorResult> getDependencyResolverResult() {
                    return Optional.ofNullable(res.getDependencyResolutionResult()).map(r -> new DependencyCollectorResult(){
                        final /* synthetic */ DependencyResolutionResult val$r;
                        final /* synthetic */ DefaultSession val$session;
                        {
                            this.val$r = dependencyResolutionResult;
                            this.val$session = defaultSession;
                        }

                        public List<Exception> getExceptions() {
                            return this.val$r.getCollectionErrors();
                        }

                        public Node getRoot() {
                            return this.val$session.getNode(this.val$r.getDependencyGraph());
                        }
                    });
                }
            };
        }
        catch (ProjectBuildingException e) {
            throw new ProjectBuilderException("Unable to build project", (Exception)e);
        }
    }
}

