/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginConfiguration;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.api.model.Resource;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class BuildBase
extends PluginConfiguration
implements Serializable,
InputLocationTracker {
    final String defaultGoal;
    final List<Resource> resources;
    final List<Resource> testResources;
    final String directory;
    final String finalName;
    final List<String> filters;
    final InputLocation defaultGoalLocation;
    final InputLocation resourcesLocation;
    final InputLocation testResourcesLocation;
    final InputLocation directoryLocation;
    final InputLocation finalNameLocation;
    final InputLocation filtersLocation;

    BuildBase(Collection<Plugin> plugins, PluginManagement pluginManagement, String defaultGoal, Collection<Resource> resources, Collection<Resource> testResources, String directory, String finalName, Collection<String> filters, Map<Object, InputLocation> locations, InputLocation location, InputLocation pluginsLocation, InputLocation pluginManagementLocation, InputLocation defaultGoalLocation, InputLocation resourcesLocation, InputLocation testResourcesLocation, InputLocation directoryLocation, InputLocation finalNameLocation, InputLocation filtersLocation) {
        super(plugins, pluginManagement, locations, location, pluginsLocation, pluginManagementLocation);
        this.defaultGoal = defaultGoal;
        this.resources = ImmutableCollections.copy(resources);
        this.testResources = ImmutableCollections.copy(testResources);
        this.directory = directory;
        this.finalName = finalName;
        this.filters = ImmutableCollections.copy(filters);
        this.defaultGoalLocation = defaultGoalLocation;
        this.resourcesLocation = resourcesLocation;
        this.testResourcesLocation = testResourcesLocation;
        this.directoryLocation = directoryLocation;
        this.finalNameLocation = finalNameLocation;
        this.filtersLocation = filtersLocation;
    }

    public String getDefaultGoal() {
        return this.defaultGoal;
    }

    @Nonnull
    public List<Resource> getResources() {
        return this.resources;
    }

    @Nonnull
    public List<Resource> getTestResources() {
        return this.testResources;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFinalName() {
        return this.finalName;
    }

    @Nonnull
    public List<String> getFilters() {
        return this.filters;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "defaultGoal": {
                    return this.defaultGoalLocation;
                }
                case "resources": {
                    return this.resourcesLocation;
                }
                case "testResources": {
                    return this.testResourcesLocation;
                }
                case "directory": {
                    return this.directoryLocation;
                }
                case "finalName": {
                    return this.finalNameLocation;
                }
                case "filters": {
                    return this.filtersLocation;
                }
            }
        }
        return super.getLocation(key);
    }

    @Override
    @Nonnull
    public Builder with() {
        return BuildBase.newBuilder(this);
    }

    @Override
    @Nonnull
    public BuildBase withPlugins(Collection<Plugin> plugins) {
        return ((Builder)this.with().plugins((Collection)plugins)).build();
    }

    @Override
    @Nonnull
    public BuildBase withPluginManagement(PluginManagement pluginManagement) {
        return this.with().pluginManagement(pluginManagement).build();
    }

    @Nonnull
    public BuildBase withDefaultGoal(String defaultGoal) {
        return this.with().defaultGoal(defaultGoal).build();
    }

    @Nonnull
    public BuildBase withResources(Collection<Resource> resources) {
        return this.with().resources(resources).build();
    }

    @Nonnull
    public BuildBase withTestResources(Collection<Resource> testResources) {
        return this.with().testResources(testResources).build();
    }

    @Nonnull
    public BuildBase withDirectory(String directory) {
        return this.with().directory(directory).build();
    }

    @Nonnull
    public BuildBase withFinalName(String finalName) {
        return this.with().finalName(finalName).build();
    }

    @Nonnull
    public BuildBase withFilters(Collection<String> filters) {
        return this.with().filters(filters).build();
    }

    @Nonnull
    public static BuildBase newInstance() {
        return BuildBase.newInstance(true);
    }

    @Nonnull
    public static BuildBase newInstance(boolean withDefaults) {
        return BuildBase.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return BuildBase.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(BuildBase from) {
        return BuildBase.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(BuildBase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @Override
    public String toString() {
        return "BuildBase {" + super.toString() + "}";
    }

    @NotThreadSafe
    public static class Builder
    extends PluginConfiguration.Builder {
        BuildBase base;
        String defaultGoal;
        Collection<Resource> resources;
        Collection<Resource> testResources;
        String directory;
        String finalName;
        Collection<String> filters;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(BuildBase base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.defaultGoal = base.defaultGoal;
                this.resources = base.resources;
                this.testResources = base.testResources;
                this.directory = base.directory;
                this.finalName = base.finalName;
                this.filters = base.filters;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Override
        @Nonnull
        public Builder pluginManagement(PluginManagement pluginManagement) {
            this.pluginManagement = pluginManagement;
            return this;
        }

        @Nonnull
        public Builder defaultGoal(String defaultGoal) {
            this.defaultGoal = defaultGoal;
            return this;
        }

        @Nonnull
        public Builder resources(Collection<Resource> resources) {
            this.resources = resources;
            return this;
        }

        @Nonnull
        public Builder testResources(Collection<Resource> testResources) {
            this.testResources = testResources;
            return this;
        }

        @Nonnull
        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        @Nonnull
        public Builder finalName(String finalName) {
            this.finalName = finalName;
            return this;
        }

        @Nonnull
        public Builder filters(Collection<String> filters) {
            this.filters = filters;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public BuildBase build() {
            if (!(this.base == null || this.plugins != null && this.plugins != this.base.plugins || this.pluginManagement != null && this.pluginManagement != this.base.pluginManagement || this.defaultGoal != null && this.defaultGoal != this.base.defaultGoal || this.resources != null && this.resources != this.base.resources || this.testResources != null && this.testResources != this.base.testResources || this.directory != null && this.directory != this.base.directory || this.finalName != null && this.finalName != this.base.finalName || this.filters != null && this.filters != this.base.filters)) {
                return this.base;
            }
            Map locations = null;
            InputLocation location = null;
            InputLocation pluginsLocation = null;
            InputLocation pluginManagementLocation = null;
            InputLocation defaultGoalLocation = null;
            InputLocation resourcesLocation = null;
            InputLocation testResourcesLocation = null;
            InputLocation directoryLocation = null;
            InputLocation finalNameLocation = null;
            InputLocation filtersLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = (InputLocation)locations.remove("");
                pluginsLocation = (InputLocation)locations.remove("plugins");
                pluginManagementLocation = (InputLocation)locations.remove("pluginManagement");
                defaultGoalLocation = (InputLocation)locations.remove("defaultGoal");
                resourcesLocation = (InputLocation)locations.remove("resources");
                testResourcesLocation = (InputLocation)locations.remove("testResources");
                directoryLocation = (InputLocation)locations.remove("directory");
                finalNameLocation = (InputLocation)locations.remove("finalName");
                filtersLocation = (InputLocation)locations.remove("filters");
            }
            return new BuildBase(this.plugins != null ? this.plugins : (this.base != null ? this.base.plugins : null), this.pluginManagement != null ? this.pluginManagement : (this.base != null ? this.base.pluginManagement : null), this.defaultGoal != null ? this.defaultGoal : (this.base != null ? this.base.defaultGoal : null), this.resources != null ? this.resources : (this.base != null ? this.base.resources : null), this.testResources != null ? this.testResources : (this.base != null ? this.base.testResources : null), this.directory != null ? this.directory : (this.base != null ? this.base.directory : null), this.finalName != null ? this.finalName : (this.base != null ? this.base.finalName : null), this.filters != null ? this.filters : (this.base != null ? this.base.filters : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), pluginsLocation != null ? pluginsLocation : (this.base != null ? this.base.pluginsLocation : null), pluginManagementLocation != null ? pluginManagementLocation : (this.base != null ? this.base.pluginManagementLocation : null), defaultGoalLocation != null ? defaultGoalLocation : (this.base != null ? this.base.defaultGoalLocation : null), resourcesLocation != null ? resourcesLocation : (this.base != null ? this.base.resourcesLocation : null), testResourcesLocation != null ? testResourcesLocation : (this.base != null ? this.base.testResourcesLocation : null), directoryLocation != null ? directoryLocation : (this.base != null ? this.base.directoryLocation : null), finalNameLocation != null ? finalNameLocation : (this.base != null ? this.base.finalNameLocation : null), filtersLocation != null ? filtersLocation : (this.base != null ? this.base.filtersLocation : null));
        }
    }
}

