/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.internal.impl.DefaultMojoExecution;
import org.apache.maven.internal.impl.DefaultSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;

public class PluginParameterExpressionEvaluatorV4
implements TypeAwareExpressionEvaluator {
    private Session session;
    private MojoExecution mojoExecution;
    private Project project;
    private Path basedir;
    private Properties properties;

    public PluginParameterExpressionEvaluatorV4(Session session, Project project) {
        this(session, project, null);
    }

    public PluginParameterExpressionEvaluatorV4(Session session, Project project, MojoExecution mojoExecution) {
        Optional projectFile;
        this.session = session;
        this.mojoExecution = mojoExecution;
        this.properties = new Properties();
        this.project = project;
        this.properties.putAll((Map<?, ?>)session.getUserProperties());
        this.properties.putAll((Map<?, ?>)session.getSystemProperties());
        Path basedir = null;
        if (project != null && (projectFile = project.getBasedir()).isPresent()) {
            basedir = ((Path)projectFile.get()).toAbsolutePath();
        }
        if (basedir == null) {
            basedir = session.getExecutionRootDirectory();
        }
        if (basedir == null) {
            basedir = Paths.get(System.getProperty("user.dir"), new String[0]);
        }
        this.basedir = basedir;
    }

    public Object evaluate(String expr) throws ExpressionEvaluationException {
        return this.evaluate(expr, null);
    }

    public Object evaluate(String expr, Class<?> type) throws ExpressionEvaluationException {
        String val;
        int exprStartDelimiter;
        String pathExpression;
        int pathSeparator;
        Object value = null;
        if (expr == null) {
            return null;
        }
        String expression = this.stripTokens(expr);
        if (expression.equals(expr)) {
            int lastIndex;
            int index = expr.indexOf("${");
            if (index >= 0 && (lastIndex = expr.indexOf(125, index)) >= 0) {
                Object subResult;
                String retVal = expr.substring(0, index);
                retVal = index > 0 && expr.charAt(index - 1) == '$' ? retVal + expr.substring(index + 1, lastIndex + 1) : ((subResult = this.evaluate(expr.substring(index, lastIndex + 1))) != null ? retVal + subResult : retVal + "$" + expr.substring(index + 1, lastIndex + 1));
                retVal = retVal + this.evaluate(expr.substring(lastIndex + 1));
                return retVal;
            }
            if (expression.contains("$$")) {
                return expression.replaceAll("\\$\\$", "\\$");
            }
            return expression;
        }
        if ("localRepository".equals(expression)) {
            value = this.session.getLocalRepository();
        } else if ("session".equals(expression)) {
            value = this.session;
        } else if (expression.startsWith("session")) {
            try {
                pathSeparator = expression.indexOf(47);
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate((String)pathExpression, (Object)this.session);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate((String)expression.substring(1), (Object)this.session);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, (Throwable)e);
            }
        } else if ("reactorProjects".equals(expression)) {
            value = this.session.getProjects();
        } else if ("project".equals(expression)) {
            value = this.project;
        } else if ("executedProject".equals(expression)) {
            value = ((DefaultSession)this.session).getProject(((DefaultSession)this.session).getMavenSession().getCurrentProject().getExecutionProject());
        } else if (expression.startsWith("project") || expression.startsWith("pom")) {
            try {
                pathSeparator = expression.indexOf(47);
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(0, pathSeparator);
                    value = ReflectionValueExtractor.evaluate((String)pathExpression, (Object)this.project);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate((String)expression.substring(1), (Object)this.project);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, (Throwable)e);
            }
        } else if (!expression.equals("repositorySystemSession")) {
            if (expression.equals("mojo") || expression.equals("mojoExecution")) {
                value = new DefaultMojoExecution(this.mojoExecution);
            } else if (expression.startsWith("mojo")) {
                try {
                    pathSeparator = expression.indexOf(47);
                    if (pathSeparator > 0) {
                        pathExpression = expression.substring(1, pathSeparator);
                        value = ReflectionValueExtractor.evaluate((String)pathExpression, (Object)this.mojoExecution);
                        value = value + expression.substring(pathSeparator);
                    }
                    value = ReflectionValueExtractor.evaluate((String)expression.substring(1), (Object)this.mojoExecution);
                }
                catch (Exception e) {
                    throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, (Throwable)e);
                }
            } else if (expression.equals("plugin")) {
                value = this.mojoExecution.getMojoDescriptor().getPluginDescriptor();
            } else if (expression.startsWith("plugin")) {
                try {
                    pathSeparator = expression.indexOf(47);
                    PluginDescriptor pluginDescriptor = this.mojoExecution.getMojoDescriptor().getPluginDescriptor();
                    if (pathSeparator > 0) {
                        String pathExpression2 = expression.substring(1, pathSeparator);
                        value = ReflectionValueExtractor.evaluate((String)pathExpression2, (Object)pluginDescriptor);
                        value = value + expression.substring(pathSeparator);
                    }
                    value = ReflectionValueExtractor.evaluate((String)expression.substring(1), (Object)pluginDescriptor);
                }
                catch (Exception e) {
                    throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, (Throwable)e);
                }
            } else if ("settings".equals(expression)) {
                value = this.session.getSettings();
            } else if (expression.startsWith("settings")) {
                try {
                    pathSeparator = expression.indexOf(47);
                    if (pathSeparator > 0) {
                        pathExpression = expression.substring(1, pathSeparator);
                        value = ReflectionValueExtractor.evaluate((String)pathExpression, (Object)this.session.getSettings());
                        value = value + expression.substring(pathSeparator);
                    }
                    value = ReflectionValueExtractor.evaluate((String)expression.substring(1), (Object)this.session.getSettings());
                }
                catch (Exception e) {
                    throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, (Throwable)e);
                }
            } else if ("basedir".equals(expression)) {
                value = this.basedir.toString();
            } else if (expression.startsWith("basedir") && (pathSeparator = expression.indexOf(47)) > 0) {
                value = this.basedir.toString() + expression.substring(pathSeparator);
            }
        }
        if (value != null && type != null && !(value instanceof String) && !PluginParameterExpressionEvaluatorV4.isTypeCompatible(type, value)) {
            value = null;
        }
        if (value == null) {
            if (this.properties != null) {
                value = this.properties.getProperty(expression);
            }
            if (value == null && this.project != null && this.project.getModel().getProperties() != null) {
                value = this.project.getModel().getProperties().get(expression);
            }
        }
        if (value instanceof String && (exprStartDelimiter = (val = (String)value).indexOf("${")) >= 0) {
            value = exprStartDelimiter > 0 ? val.substring(0, exprStartDelimiter) + this.evaluate(val.substring(exprStartDelimiter)) : this.evaluate(val.substring(exprStartDelimiter));
        }
        return value;
    }

    private static boolean isTypeCompatible(Class<?> type, Object value) {
        if (type.isInstance(value)) {
            return true;
        }
        return (type.isPrimitive() || type.getName().startsWith("java.lang.")) && value.getClass().getName().startsWith("java.lang.");
    }

    private String stripTokens(String expr) {
        if (expr.startsWith("${") && expr.indexOf(125) == expr.length() - 1) {
            expr = expr.substring(2, expr.length() - 1);
        }
        return expr;
    }

    public File alignToBaseDirectory(File file) {
        if (file != null && !file.isAbsolute()) {
            file = file.getPath().startsWith(File.separator) ? file.getAbsoluteFile() : this.basedir.resolve(file.getPath()).normalize().toAbsolutePath().toFile();
        }
        return file;
    }
}

