/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingResult;

class DefaultProjectBuildingResult
implements ProjectBuildingResult {
    private final String projectId;
    private final File pomFile;
    private final MavenProject project;
    private final List<ModelProblem> problems;
    private final DependencyResolutionResult dependencyResolutionResult;

    DefaultProjectBuildingResult(MavenProject project, List<ModelProblem> problems, DependencyResolutionResult dependencyResolutionResult) {
        this.projectId = project != null ? project.getGroupId() + ':' + project.getArtifactId() + ':' + project.getVersion() : "";
        this.pomFile = project != null ? project.getFile() : null;
        this.project = project;
        this.problems = problems != null ? problems : Collections.emptyList();
        this.dependencyResolutionResult = dependencyResolutionResult;
    }

    DefaultProjectBuildingResult(String projectId, File pomFile, List<ModelProblem> problems) {
        this.projectId = projectId != null ? projectId : "";
        this.pomFile = pomFile;
        this.project = null;
        this.problems = problems != null ? problems : Collections.emptyList();
        this.dependencyResolutionResult = null;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public File getPomFile() {
        return this.pomFile;
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public List<ModelProblem> getProblems() {
        return this.problems;
    }

    @Override
    public DependencyResolutionResult getDependencyResolutionResult() {
        return this.dependencyResolutionResult;
    }
}

