/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.xml.XmlNode;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class ConfigurationContainer
implements Serializable,
InputLocationTracker {
    final String inherited;
    final XmlNode configuration;
    final InputLocation location;
    final InputLocation inheritedLocation;
    final InputLocation configurationLocation;
    final Map<Object, InputLocation> locations;

    ConfigurationContainer(String inherited, XmlNode configuration, Map<Object, InputLocation> locations, InputLocation location, InputLocation inheritedLocation, InputLocation configurationLocation) {
        this.inherited = inherited;
        this.configuration = configuration;
        this.locations = ImmutableCollections.copy(locations);
        this.location = location;
        this.inheritedLocation = inheritedLocation;
        this.configurationLocation = configurationLocation;
    }

    public String getInherited() {
        return this.inherited;
    }

    public XmlNode getConfiguration() {
        return this.configuration;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "inherited": {
                    return this.inheritedLocation;
                }
                case "configuration": {
                    return this.configurationLocation;
                }
            }
        }
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return ConfigurationContainer.newBuilder(this);
    }

    @Nonnull
    public ConfigurationContainer withInherited(String inherited) {
        return this.with().inherited(inherited).build();
    }

    @Nonnull
    public ConfigurationContainer withConfiguration(XmlNode configuration) {
        return this.with().configuration(configuration).build();
    }

    @Nonnull
    public static ConfigurationContainer newInstance() {
        return ConfigurationContainer.newInstance(true);
    }

    @Nonnull
    public static ConfigurationContainer newInstance(boolean withDefaults) {
        return ConfigurationContainer.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return ConfigurationContainer.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(ConfigurationContainer from) {
        return ConfigurationContainer.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(ConfigurationContainer from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isInherited() {
        return this.getInherited() != null ? Boolean.parseBoolean(this.getInherited()) : true;
    }

    @NotThreadSafe
    public static class Builder {
        ConfigurationContainer base;
        String inherited;
        XmlNode configuration;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(ConfigurationContainer base, boolean forceCopy) {
            if (forceCopy) {
                this.inherited = base.inherited;
                this.configuration = base.configuration;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder inherited(String inherited) {
            this.inherited = inherited;
            return this;
        }

        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap<Object, InputLocation>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public ConfigurationContainer build() {
            if (!(this.base == null || this.inherited != null && this.inherited != this.base.inherited || this.configuration != null && this.configuration != this.base.configuration)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation inheritedLocation = null;
            InputLocation configurationLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = locations.remove("");
                inheritedLocation = locations.remove("inherited");
                configurationLocation = locations.remove("configuration");
            }
            return new ConfigurationContainer(this.inherited != null ? this.inherited : (this.base != null ? this.base.inherited : null), (XmlNode)(this.configuration != null ? this.configuration : (this.base != null ? this.base.configuration : null)), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), inheritedLocation != null ? inheritedLocation : (this.base != null ? this.base.inheritedLocation : null), configurationLocation != null ? configurationLocation : (this.base != null ? this.base.configurationLocation : null));
        }
    }
}

