/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.feature;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public final class Features {
    private Features() {
    }

    public static Feature buildConsumer(Properties userProperties) {
        return Features.buildConsumer(Features.toMap(userProperties));
    }

    public static Feature buildConsumer(Map<String, String> userProperties) {
        return new Feature(userProperties, "maven.experimental.buildconsumer", "true");
    }

    private static Map<String, String> toMap(Properties properties) {
        return properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (prev, next) -> next, HashMap::new));
    }

    public static class Feature {
        private final boolean active;
        private final String name;

        Feature(Map<String, String> userProperties, String name, String defaultValue) {
            this.name = name;
            this.active = "true".equals(userProperties.getOrDefault(name, defaultValue));
        }

        public boolean isActive() {
            return this.active;
        }

        public String propertyName() {
            return this.name;
        }
    }
}

