/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.lifecycle.Lifecycle;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultLifecycles {
    public static final String[] STANDARD_LIFECYCLES = new String[]{"clean", "default", "site", "wrapper"};
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PlexusContainer plexusContainer;

    public DefaultLifecycles() {
        this.plexusContainer = null;
    }

    @Inject
    public DefaultLifecycles(PlexusContainer plexusContainer) {
        this.plexusContainer = plexusContainer;
    }

    public Lifecycle get(String phase) {
        return this.getPhaseToLifecycleMap().get(phase);
    }

    public Map<String, Lifecycle> getPhaseToLifecycleMap() {
        HashMap<String, Lifecycle> phaseToLifecycleMap = new HashMap<String, Lifecycle>();
        for (Lifecycle lifecycle : this.getLifeCycles()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Lifecycle " + lifecycle);
            }
            for (String phase : lifecycle.getPhases()) {
                if (!phaseToLifecycleMap.containsKey(phase)) {
                    phaseToLifecycleMap.put(phase, lifecycle);
                    continue;
                }
                Lifecycle original = (Lifecycle)phaseToLifecycleMap.get(phase);
                this.logger.warn("Duplicated lifecycle phase " + phase + ". Defined in " + original.getId() + " but also in " + lifecycle.getId());
            }
        }
        return phaseToLifecycleMap;
    }

    public List<Lifecycle> getLifeCycles() {
        List<String> lifecycleIds = Arrays.asList(STANDARD_LIFECYCLES);
        Comparator comparator = (l, r) -> {
            int lx = lifecycleIds.indexOf(l);
            int rx = lifecycleIds.indexOf(r);
            if (lx < 0 || rx < 0) {
                return rx - lx;
            }
            return lx - rx;
        };
        Map<String, Lifecycle> lifecyclesMap = this.lookupLifecycles();
        return lifecyclesMap.values().stream().peek(l -> Objects.requireNonNull(l.getId(), "A lifecycle must have an id.")).sorted(Comparator.comparing(Lifecycle::getId, comparator)).collect(Collectors.toList());
    }

    private Map<String, Lifecycle> lookupLifecycles() {
        if (this.plexusContainer == null) {
            return new HashMap<String, Lifecycle>();
        }
        try {
            return this.plexusContainer.lookupMap(Lifecycle.class);
        }
        catch (ComponentLookupException e) {
            throw new IllegalStateException("Unable to lookup lifecycles from the plexus container", e);
        }
    }

    public String getLifecyclePhaseList() {
        return this.getLifeCycles().stream().flatMap(l -> l.getPhases().stream()).collect(Collectors.joining(", "));
    }
}

