/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.SessionScoped;
import org.apache.maven.api.Node;
import org.apache.maven.api.Project;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.ResolutionScope;
import org.apache.maven.api.Scope;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.MavenException;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.internal.impl.AbstractSession;
import org.apache.maven.internal.impl.DefaultProject;
import org.apache.maven.internal.impl.DefaultSession;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.internal.LifecycleDependencyResolver;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

@Named
@SessionScoped
public class DefaultProjectManager
implements ProjectManager {
    private final Session session;
    private final ArtifactManager artifactManager;
    private final PlexusContainer container;

    @Inject
    public DefaultProjectManager(Session session, ArtifactManager artifactManager, PlexusContainer container) {
        this.session = session;
        this.artifactManager = artifactManager;
        this.container = container;
    }

    @Nonnull
    public Optional<Path> getPath(Project project) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Nonnull
    public Collection<org.apache.maven.api.Artifact> getAttachedArtifacts(Project project) {
        AbstractSession session = ((DefaultProject)project).getSession();
        Collection attached = this.getMavenProject(project).getAttachedArtifacts().stream().map(RepositoryUtils::toArtifact).map(session::getArtifact).collect(Collectors.toList());
        return Collections.unmodifiableCollection(attached);
    }

    public void attachArtifact(Project project, org.apache.maven.api.Artifact artifact, Path path) {
        this.getMavenProject(project).addAttachedArtifact(RepositoryUtils.toArtifact(((DefaultProject)project).getSession().toArtifact(artifact)));
        this.artifactManager.setPath(artifact, path);
    }

    public List<String> getCompileSourceRoots(Project project) {
        List<String> roots = this.getMavenProject(project).getCompileSourceRoots();
        return Collections.unmodifiableList(roots);
    }

    public void addCompileSourceRoot(Project project, String sourceRoot) {
        List<String> roots = this.getMavenProject(project).getCompileSourceRoots();
        roots.add(sourceRoot);
    }

    public List<String> getTestCompileSourceRoots(Project project) {
        List<String> roots = this.getMavenProject(project).getTestCompileSourceRoots();
        return Collections.unmodifiableList(roots);
    }

    public void addTestCompileSourceRoot(Project project, String sourceRoot) {
        List<String> roots = this.getMavenProject(project).getTestCompileSourceRoots();
        roots.add(sourceRoot);
    }

    public List<RemoteRepository> getRepositories(Project project) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public List<org.apache.maven.api.Artifact> getResolvedDependencies(Project project, ResolutionScope scope) {
        Collection<String> toResolve = this.toScopes(scope);
        try {
            LifecycleDependencyResolver lifecycleDependencyResolver = (LifecycleDependencyResolver)this.container.lookup(LifecycleDependencyResolver.class);
            Set<Artifact> artifacts = lifecycleDependencyResolver.resolveProjectArtifacts(this.getMavenProject(project), toResolve, toResolve, ((DefaultSession)this.session).getMavenSession(), false, Collections.emptySet());
            return artifacts.stream().map(RepositoryUtils::toArtifact).map(((DefaultSession)this.session)::getArtifact).collect(Collectors.toList());
        }
        catch (LifecycleExecutionException | ComponentLookupException e) {
            throw new MavenException("Unable to resolve project dependencies", e);
        }
    }

    public Node getCollectedDependencies(Project project, ResolutionScope scope) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void setProperty(Project project, String key, String value) {
        this.getMavenProject(project).getProperties().setProperty(key, value);
    }

    private MavenProject getMavenProject(Project project) {
        return ((DefaultProject)project).getProject();
    }

    private Collection<String> toScopes(ResolutionScope scope) {
        return scope.scopes().stream().map(Scope::id).collect(Collectors.toList());
    }
}

