/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.TrackableBase;
import org.apache.maven.settings.WrapperList;

@Generated
public class Settings
extends TrackableBase
implements Serializable,
Cloneable {
    private Proxy activeProxy;
    private Map<String, Profile> profileMap;

    public Settings() {
        this(org.apache.maven.api.settings.Settings.newInstance());
    }

    public Settings(org.apache.maven.api.settings.Settings delegate) {
        super((org.apache.maven.api.settings.TrackableBase)delegate);
    }

    @Override
    public Settings clone() {
        return new Settings(this.getDelegate());
    }

    public org.apache.maven.api.settings.Settings getDelegate() {
        return (org.apache.maven.api.settings.Settings)this.delegate;
    }

    public String getModelEncoding() {
        return this.getDelegate().getModelEncoding();
    }

    public String getLocalRepository() {
        return this.getDelegate().getLocalRepository();
    }

    public void setLocalRepository(String localRepository) {
        this.delegate = this.getDelegate().withLocalRepository(localRepository);
    }

    public boolean isInteractiveMode() {
        return this.getDelegate().isInteractiveMode();
    }

    public void setInteractiveMode(boolean interactiveMode) {
        this.delegate = this.getDelegate().withInteractiveMode(interactiveMode);
    }

    public boolean isUsePluginRegistry() {
        return this.getDelegate().isUsePluginRegistry();
    }

    public void setUsePluginRegistry(boolean usePluginRegistry) {
        this.delegate = this.getDelegate().withUsePluginRegistry(usePluginRegistry);
    }

    public boolean isOffline() {
        return this.getDelegate().isOffline();
    }

    public void setOffline(boolean offline) {
        this.delegate = this.getDelegate().withOffline(offline);
    }

    @Nonnull
    public List<Proxy> getProxies() {
        return new WrapperList<Proxy, org.apache.maven.api.settings.Proxy>(() -> ((org.apache.maven.api.settings.Settings)this.getDelegate()).getProxies(), l -> {
            this.delegate = this.getDelegate().withProxies((Collection)l);
        }, Proxy::new, Proxy::getDelegate);
    }

    public void setProxies(List<Proxy> proxies) {
        this.delegate = this.getDelegate().withProxies((Collection)proxies.stream().map(c -> c.getDelegate()).collect(Collectors.toList()));
    }

    public void addProxy(Proxy proxy) {
        this.delegate = this.getDelegate().withProxies((Collection)Stream.concat(this.getDelegate().getProxies().stream(), Stream.of(proxy.getDelegate())).collect(Collectors.toList()));
    }

    @Nonnull
    public List<Server> getServers() {
        return new WrapperList<Server, org.apache.maven.api.settings.Server>(() -> ((org.apache.maven.api.settings.Settings)this.getDelegate()).getServers(), l -> {
            this.delegate = this.getDelegate().withServers((Collection)l);
        }, Server::new, Server::getDelegate);
    }

    public void setServers(List<Server> servers) {
        this.delegate = this.getDelegate().withServers((Collection)servers.stream().map(c -> c.getDelegate()).collect(Collectors.toList()));
    }

    public void addServer(Server server) {
        this.delegate = this.getDelegate().withServers((Collection)Stream.concat(this.getDelegate().getServers().stream(), Stream.of(server.getDelegate())).collect(Collectors.toList()));
    }

    @Nonnull
    public List<Mirror> getMirrors() {
        return new WrapperList<Mirror, org.apache.maven.api.settings.Mirror>(() -> ((org.apache.maven.api.settings.Settings)this.getDelegate()).getMirrors(), l -> {
            this.delegate = this.getDelegate().withMirrors((Collection)l);
        }, Mirror::new, Mirror::getDelegate);
    }

    public void setMirrors(List<Mirror> mirrors) {
        this.delegate = this.getDelegate().withMirrors((Collection)mirrors.stream().map(c -> c.getDelegate()).collect(Collectors.toList()));
    }

    public void addMirror(Mirror mirror) {
        this.delegate = this.getDelegate().withMirrors((Collection)Stream.concat(this.getDelegate().getMirrors().stream(), Stream.of(mirror.getDelegate())).collect(Collectors.toList()));
    }

    @Nonnull
    public List<Profile> getProfiles() {
        return new WrapperList<Profile, org.apache.maven.api.settings.Profile>(() -> ((org.apache.maven.api.settings.Settings)this.getDelegate()).getProfiles(), l -> {
            this.delegate = this.getDelegate().withProfiles((Collection)l);
        }, Profile::new, Profile::getDelegate);
    }

    public void setProfiles(List<Profile> profiles) {
        this.delegate = this.getDelegate().withProfiles((Collection)profiles.stream().map(c -> c.getDelegate()).collect(Collectors.toList()));
    }

    public void addProfile(Profile profile) {
        this.delegate = this.getDelegate().withProfiles((Collection)Stream.concat(this.getDelegate().getProfiles().stream(), Stream.of(profile.getDelegate())).collect(Collectors.toList()));
    }

    @Nonnull
    public List<String> getActiveProfiles() {
        return new WrapperList<String, String>(() -> ((org.apache.maven.api.settings.Settings)this.getDelegate()).getActiveProfiles(), this::setActiveProfiles, s -> s, s -> s);
    }

    public void setActiveProfiles(List<String> activeProfiles) {
        this.delegate = this.getDelegate().withActiveProfiles(activeProfiles);
    }

    public void addActiveProfile(String activeProfile) {
        this.delegate = this.getDelegate().withActiveProfiles((Collection)Stream.concat(this.getDelegate().getActiveProfiles().stream(), Stream.of(activeProfile)).collect(Collectors.toList()));
    }

    @Nonnull
    public List<String> getPluginGroups() {
        return new WrapperList<String, String>(() -> ((org.apache.maven.api.settings.Settings)this.getDelegate()).getPluginGroups(), this::setPluginGroups, s -> s, s -> s);
    }

    public void setPluginGroups(List<String> pluginGroups) {
        this.delegate = this.getDelegate().withPluginGroups(pluginGroups);
    }

    public void addPluginGroup(String pluginGroup) {
        this.delegate = this.getDelegate().withPluginGroups((Collection)Stream.concat(this.getDelegate().getPluginGroups().stream(), Stream.of(pluginGroup)).collect(Collectors.toList()));
    }

    public static List<org.apache.maven.api.settings.Settings> settingsToApiV4(List<Settings> list) {
        return list != null ? new WrapperList<org.apache.maven.api.settings.Settings, Settings>(list, Settings::getDelegate, Settings::new) : null;
    }

    public static List<Settings> settingsToApiV3(List<org.apache.maven.api.settings.Settings> list) {
        return list != null ? new WrapperList<Settings, org.apache.maven.api.settings.Settings>(list, Settings::new, Settings::getDelegate) : null;
    }

    public Boolean getInteractiveMode() {
        return this.isInteractiveMode();
    }

    public void flushActiveProxy() {
        this.activeProxy = null;
    }

    public synchronized Proxy getActiveProxy() {
        List<Proxy> proxies;
        if (this.activeProxy == null && (proxies = this.getProxies()) != null && !proxies.isEmpty()) {
            for (Proxy proxy : proxies) {
                if (!proxy.isActive()) continue;
                this.activeProxy = proxy;
                break;
            }
        }
        return this.activeProxy;
    }

    public Server getServer(String serverId) {
        Server match = null;
        List<Server> servers = this.getServers();
        if (servers != null && serverId != null) {
            for (Server server : servers) {
                if (!serverId.equals(server.getId())) continue;
                match = server;
                break;
            }
        }
        return match;
    }

    @Deprecated
    public Mirror getMirrorOf(String repositoryId) {
        Mirror match = null;
        List<Mirror> mirrors = this.getMirrors();
        if (mirrors != null && repositoryId != null) {
            for (Mirror mirror : mirrors) {
                if (!repositoryId.equals(mirror.getMirrorOf())) continue;
                match = mirror;
                break;
            }
        }
        return match;
    }

    public void flushProfileMap() {
        this.profileMap = null;
    }

    public Map<String, Profile> getProfilesAsMap() {
        if (this.profileMap == null) {
            this.profileMap = new LinkedHashMap<String, Profile>();
            if (this.getProfiles() != null) {
                for (Profile profile : this.getProfiles()) {
                    this.profileMap.put(profile.getId(), profile);
                }
            }
        }
        return this.profileMap;
    }
}

