/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.transform.pull;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class XmlUtils {
    public static ByteArrayInputStream writeDocument(XmlStreamReader reader, XmlPullParser parser) throws IOException, XmlPullParserException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = XmlUtils.newWriter(reader, baos);
        XmlUtils.writeDocument(parser, writer);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static void writeDocument(XmlPullParser parser, Writer writer) throws IOException, XmlPullParserException {
        MXSerializer serializer = new MXSerializer();
        serializer.setOutput(writer);
        block13: while (parser.nextToken() != 1) {
            switch (parser.getEventType()) {
                case 0: {
                    serializer.startDocument(parser.getInputEncoding(), Boolean.valueOf(true));
                    continue block13;
                }
                case 1: {
                    serializer.endDocument();
                }
                case 2: {
                    int i;
                    int nsStart = parser.getNamespaceCount(parser.getDepth() - 1);
                    int nsEnd = parser.getNamespaceCount(parser.getDepth());
                    for (i = nsStart; i < nsEnd; ++i) {
                        String prefix = parser.getNamespacePrefix(i);
                        String ns = parser.getNamespaceUri(i);
                        serializer.setPrefix(prefix, ns);
                    }
                    serializer.startTag(parser.getNamespace(), parser.getName());
                    for (i = 0; i < parser.getAttributeCount(); ++i) {
                        serializer.attribute(parser.getAttributeNamespace(i), parser.getAttributeName(i), parser.getAttributeValue(i));
                    }
                    continue block13;
                }
                case 3: {
                    serializer.endTag(parser.getNamespace(), parser.getName());
                    continue block13;
                }
                case 4: {
                    serializer.text(XmlUtils.normalize(parser.getText()));
                    continue block13;
                }
                case 5: {
                    serializer.cdsect(parser.getText());
                    continue block13;
                }
                case 6: {
                    serializer.entityRef(parser.getName());
                    continue block13;
                }
                case 7: {
                    serializer.ignorableWhitespace(XmlUtils.normalize(parser.getText()));
                    continue block13;
                }
                case 8: {
                    serializer.processingInstruction(parser.getText());
                    continue block13;
                }
                case 9: {
                    serializer.comment(XmlUtils.normalize(parser.getText()));
                    continue block13;
                }
                case 10: {
                    serializer.docdecl(XmlUtils.normalize(parser.getText()));
                    continue block13;
                }
            }
        }
        serializer.endDocument();
    }

    private static OutputStreamWriter newWriter(XmlStreamReader reader, ByteArrayOutputStream baos) throws UnsupportedEncodingException {
        if (reader.getEncoding() != null) {
            return new OutputStreamWriter((OutputStream)baos, reader.getEncoding());
        }
        return new OutputStreamWriter(baos);
    }

    private static String normalize(String input) {
        if (input.indexOf(10) >= 0 && !"\n".equals(System.lineSeparator())) {
            return input.replace("\n", System.lineSeparator());
        }
        return input;
    }
}

