/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.builder;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.BuildSummary;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.LifecycleModuleBuilder;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.project.MavenProject;
import org.mvndaemon.mvnd.builder.DependencyGraph;
import org.mvndaemon.mvnd.builder.ProjectComparator;
import org.mvndaemon.mvnd.builder.ProjectExecutorService;
import org.mvndaemon.mvnd.builder.ReactorBuildQueue;
import org.mvndaemon.mvnd.builder.ReactorBuildStats;
import org.mvndaemon.mvnd.builder.SmartBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmartBuilderImpl {
    private final Logger logger = LoggerFactory.getLogger(SmartBuilder.class);
    private final LifecycleModuleBuilder lifecycleModuleBuilder;
    private final MavenSession rootSession;
    private final ReactorContext reactorContext;
    private final TaskSegment taskSegment;
    private final ReactorBuildQueue reactorBuildQueue;
    private final ProjectExecutorService executor;
    private final int degreeOfConcurrency;
    private final ReactorBuildStats stats;

    SmartBuilderImpl(LifecycleModuleBuilder lifecycleModuleBuilder, MavenSession session, ReactorContext reactorContext, TaskSegment taskSegment, Set<MavenProject> projects, DependencyGraph<MavenProject> graph) {
        this.lifecycleModuleBuilder = lifecycleModuleBuilder;
        this.rootSession = session;
        this.reactorContext = reactorContext;
        this.taskSegment = taskSegment;
        this.degreeOfConcurrency = session.getRequest().getDegreeOfConcurrency();
        Comparator<MavenProject> projectComparator = ProjectComparator.create(graph);
        this.reactorBuildQueue = new ReactorBuildQueue(projects, graph);
        this.executor = new ProjectExecutorService(this.degreeOfConcurrency, projectComparator);
        this.stats = ReactorBuildStats.create(projects);
    }

    private static String projectGA(MavenProject project) {
        return project.getGroupId() + ":" + project.getArtifactId();
    }

    public ReactorBuildStats build() throws ExecutionException, InterruptedException {
        Set<MavenProject> readyProjects;
        this.stats.recordStart();
        Set<MavenProject> rootProjects = this.reactorBuildQueue.getRootProjects();
        this.submitAll(rootProjects);
        long timstampSubmit = System.nanoTime();
        for (int submittedCount = rootProjects.size(); submittedCount > 0; submittedCount += readyProjects.size() - 1) {
            Set<MavenProject> bottlenecks = null;
            if (submittedCount < this.degreeOfConcurrency) {
                bottlenecks = this.reactorBuildQueue.getReadyProjects();
            }
            try {
                MavenProject completedProject = this.executor.take();
                if (bottlenecks != null) {
                    this.stats.recordBottlenecks(bottlenecks, this.degreeOfConcurrency, System.nanoTime() - timstampSubmit);
                }
                this.logCompleted(completedProject);
                readyProjects = this.reactorBuildQueue.onProjectFinish(completedProject);
                this.submitAll(readyProjects);
                timstampSubmit = System.nanoTime();
                this.logBuildQueueStatus();
                continue;
            }
            catch (ExecutionException e) {
                this.shutdown();
                throw e;
            }
        }
        this.shutdown();
        this.stats.recordStop();
        return this.stats;
    }

    private void logBuildQueueStatus() {
        int blockedCount = this.reactorBuildQueue.getBlockedCount();
        int finishedCount = this.reactorBuildQueue.getFinishedCount();
        int readyCount = this.reactorBuildQueue.getReadyCount();
        String runningProjects = "";
        if (readyCount < this.degreeOfConcurrency && blockedCount > 0) {
            runningProjects = this.reactorBuildQueue.getReadyProjects().stream().map(SmartBuilderImpl::projectGA).collect(Collectors.joining(" ", "[", "]"));
        }
        this.logger.debug("Builder state: blocked={} finished={} ready-or-running={} {}", new Object[]{blockedCount, finishedCount, readyCount, runningProjects});
    }

    private void logCompleted(MavenProject project) {
        BuildSummary buildSummary = this.rootSession.getResult().getBuildSummary(project);
        String message = "SKIPPED";
        if (buildSummary instanceof BuildSuccess) {
            message = "SUCCESS";
        } else if (buildSummary instanceof BuildFailure) {
            message = "FAILURE";
        } else if (buildSummary != null) {
            this.logger.warn("Unexpected project build summary class {}", buildSummary.getClass());
            message = "UNKNOWN";
        }
        this.logger.debug("{} build of project {}:{}", new Object[]{message, project.getGroupId(), project.getArtifactId()});
    }

    private void shutdown() {
        this.executor.shutdown();
    }

    public void cancel() {
        this.executor.cancel();
    }

    private void submitAll(Set<MavenProject> readyProjects) {
        ArrayList<ProjectBuildTask> tasks = new ArrayList<ProjectBuildTask>();
        for (MavenProject project : readyProjects) {
            tasks.add(new ProjectBuildTask(project));
            this.logger.debug("Ready {}:{}", (Object)project.getGroupId(), (Object)project.getArtifactId());
        }
        this.executor.submitAll(tasks);
    }

    void buildProject(MavenProject project) {
        this.logger.debug("STARTED build of project {}:{}", (Object)project.getGroupId(), (Object)project.getArtifactId());
        try {
            MavenSession copiedSession = this.rootSession.clone();
            this.lifecycleModuleBuilder.buildProject(copiedSession, this.rootSession, this.reactorContext, project, this.taskSegment);
        }
        catch (RuntimeException ex) {
            this.rootSession.getResult().addException((Throwable)new RuntimeException(project.getName() + ": " + ex.getMessage(), ex));
        }
    }

    class ProjectBuildTask
    implements ProjectExecutorService.ProjectRunnable {
        private final MavenProject project;

        ProjectBuildTask(MavenProject project) {
            this.project = project;
        }

        @Override
        public void run() {
            long start = System.nanoTime();
            try {
                SmartBuilderImpl.this.buildProject(this.project);
            }
            finally {
                SmartBuilderImpl.this.stats.recordServiceTime(this.project, System.nanoTime() - start);
            }
        }

        @Override
        public MavenProject getProject() {
            return this.project;
        }
    }
}

