/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.Exclusion;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Dependency
implements Serializable,
InputLocationTracker {
    final String groupId;
    final String artifactId;
    final String version;
    final String type;
    final String classifier;
    final String scope;
    final String systemPath;
    final List<Exclusion> exclusions;
    final String optional;
    final InputLocation location;
    final InputLocation groupIdLocation;
    final InputLocation artifactIdLocation;
    final InputLocation versionLocation;
    final InputLocation typeLocation;
    final InputLocation classifierLocation;
    final InputLocation scopeLocation;
    final InputLocation systemPathLocation;
    final InputLocation exclusionsLocation;
    final InputLocation optionalLocation;
    final Map<Object, InputLocation> locations;
    private volatile String managementKey;

    Dependency(String groupId, String artifactId, String version, String type, String classifier, String scope, String systemPath, Collection<Exclusion> exclusions, String optional, Map<Object, InputLocation> locations, InputLocation location, InputLocation groupIdLocation, InputLocation artifactIdLocation, InputLocation versionLocation, InputLocation typeLocation, InputLocation classifierLocation, InputLocation scopeLocation, InputLocation systemPathLocation, InputLocation exclusionsLocation, InputLocation optionalLocation) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
        this.scope = scope;
        this.systemPath = systemPath;
        this.exclusions = ImmutableCollections.copy(exclusions);
        this.optional = optional;
        this.locations = ImmutableCollections.copy(locations);
        this.location = location;
        this.groupIdLocation = groupIdLocation;
        this.artifactIdLocation = artifactIdLocation;
        this.versionLocation = versionLocation;
        this.typeLocation = typeLocation;
        this.classifierLocation = classifierLocation;
        this.scopeLocation = scopeLocation;
        this.systemPathLocation = systemPathLocation;
        this.exclusionsLocation = exclusionsLocation;
        this.optionalLocation = optionalLocation;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getScope() {
        return this.scope;
    }

    public String getSystemPath() {
        return this.systemPath;
    }

    @Nonnull
    public List<Exclusion> getExclusions() {
        return this.exclusions;
    }

    public String getOptional() {
        return this.optional;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "": {
                    return this.location;
                }
                case "groupId": {
                    return this.groupIdLocation;
                }
                case "artifactId": {
                    return this.artifactIdLocation;
                }
                case "version": {
                    return this.versionLocation;
                }
                case "type": {
                    return this.typeLocation;
                }
                case "classifier": {
                    return this.classifierLocation;
                }
                case "scope": {
                    return this.scopeLocation;
                }
                case "systemPath": {
                    return this.systemPathLocation;
                }
                case "exclusions": {
                    return this.exclusionsLocation;
                }
                case "optional": {
                    return this.optionalLocation;
                }
            }
        }
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Dependency.newBuilder(this);
    }

    @Nonnull
    public Dependency withGroupId(String groupId) {
        return this.with().groupId(groupId).build();
    }

    @Nonnull
    public Dependency withArtifactId(String artifactId) {
        return this.with().artifactId(artifactId).build();
    }

    @Nonnull
    public Dependency withVersion(String version) {
        return this.with().version(version).build();
    }

    @Nonnull
    public Dependency withType(String type) {
        return this.with().type(type).build();
    }

    @Nonnull
    public Dependency withClassifier(String classifier) {
        return this.with().classifier(classifier).build();
    }

    @Nonnull
    public Dependency withScope(String scope) {
        return this.with().scope(scope).build();
    }

    @Nonnull
    public Dependency withSystemPath(String systemPath) {
        return this.with().systemPath(systemPath).build();
    }

    @Nonnull
    public Dependency withExclusions(Collection<Exclusion> exclusions) {
        return this.with().exclusions(exclusions).build();
    }

    @Nonnull
    public Dependency withOptional(String optional) {
        return this.with().optional(optional).build();
    }

    @Nonnull
    public static Dependency newInstance() {
        return Dependency.newInstance(true);
    }

    @Nonnull
    public static Dependency newInstance(boolean withDefaults) {
        return Dependency.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Dependency.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Dependency from) {
        return Dependency.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Dependency from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isOptional() {
        return this.getOptional() != null ? Boolean.parseBoolean(this.getOptional()) : false;
    }

    public String toString() {
        return "Dependency {groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", type=" + this.getType() + "}";
    }

    public String getManagementKey() {
        if (this.managementKey == null) {
            this.managementKey = this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getType() + (this.getClassifier() != null ? ":" + this.getClassifier() : "");
        }
        return this.managementKey;
    }

    @NotThreadSafe
    public static class Builder {
        Dependency base;
        String groupId;
        String artifactId;
        String version;
        String type;
        String classifier;
        String scope;
        String systemPath;
        Collection<Exclusion> exclusions;
        String optional;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.type = "jar";
            }
        }

        Builder(Dependency base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.type = base.type;
                this.classifier = base.classifier;
                this.scope = base.scope;
                this.systemPath = base.systemPath;
                this.exclusions = base.exclusions;
                this.optional = base.optional;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        @Nonnull
        public Builder classifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        @Nonnull
        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Nonnull
        public Builder systemPath(String systemPath) {
            this.systemPath = systemPath;
            return this;
        }

        @Nonnull
        public Builder exclusions(Collection<Exclusion> exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        @Nonnull
        public Builder optional(String optional) {
            this.optional = optional;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap<Object, InputLocation>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Dependency build() {
            if (!(this.base == null || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.type != null && this.type != this.base.type || this.classifier != null && this.classifier != this.base.classifier || this.scope != null && this.scope != this.base.scope || this.systemPath != null && this.systemPath != this.base.systemPath || this.exclusions != null && this.exclusions != this.base.exclusions || this.optional != null && this.optional != this.base.optional)) {
                return this.base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation groupIdLocation = null;
            InputLocation artifactIdLocation = null;
            InputLocation versionLocation = null;
            InputLocation typeLocation = null;
            InputLocation classifierLocation = null;
            InputLocation scopeLocation = null;
            InputLocation systemPathLocation = null;
            InputLocation exclusionsLocation = null;
            InputLocation optionalLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = locations.remove("");
                groupIdLocation = locations.remove("groupId");
                artifactIdLocation = locations.remove("artifactId");
                versionLocation = locations.remove("version");
                typeLocation = locations.remove("type");
                classifierLocation = locations.remove("classifier");
                scopeLocation = locations.remove("scope");
                systemPathLocation = locations.remove("systemPath");
                exclusionsLocation = locations.remove("exclusions");
                optionalLocation = locations.remove("optional");
            }
            return new Dependency(this.groupId != null ? this.groupId : (this.base != null ? this.base.groupId : null), this.artifactId != null ? this.artifactId : (this.base != null ? this.base.artifactId : null), this.version != null ? this.version : (this.base != null ? this.base.version : null), this.type != null ? this.type : (this.base != null ? this.base.type : null), this.classifier != null ? this.classifier : (this.base != null ? this.base.classifier : null), this.scope != null ? this.scope : (this.base != null ? this.base.scope : null), this.systemPath != null ? this.systemPath : (this.base != null ? this.base.systemPath : null), this.exclusions != null ? this.exclusions : (this.base != null ? this.base.exclusions : null), this.optional != null ? this.optional : (this.base != null ? this.base.optional : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), groupIdLocation != null ? groupIdLocation : (this.base != null ? this.base.groupIdLocation : null), artifactIdLocation != null ? artifactIdLocation : (this.base != null ? this.base.artifactIdLocation : null), versionLocation != null ? versionLocation : (this.base != null ? this.base.versionLocation : null), typeLocation != null ? typeLocation : (this.base != null ? this.base.typeLocation : null), classifierLocation != null ? classifierLocation : (this.base != null ? this.base.classifierLocation : null), scopeLocation != null ? scopeLocation : (this.base != null ? this.base.scopeLocation : null), systemPathLocation != null ? systemPathLocation : (this.base != null ? this.base.systemPathLocation : null), exclusionsLocation != null ? exclusionsLocation : (this.base != null ? this.base.exclusionsLocation : null), optionalLocation != null ? optionalLocation : (this.base != null ? this.base.optionalLocation : null));
        }
    }
}

