/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.settings.IdentifiableBase;
import org.apache.maven.api.settings.Settings;
import org.codehaus.plexus.util.StringUtils;

public class MavenSettingsMerger {
    public Settings merge(Settings dominant, Settings recessive, String recessiveSourceLevel) {
        if (dominant == null) {
            return recessive;
        }
        if (recessive == null) {
            return dominant;
        }
        recessive.setSourceLevel(recessiveSourceLevel);
        Settings.Builder merged = Settings.newBuilder((Settings)dominant);
        List dominantActiveProfiles = dominant.getActiveProfiles();
        List recessiveActiveProfiles = recessive.getActiveProfiles();
        List mergedActiveProfiles = Stream.of(dominantActiveProfiles, recessiveActiveProfiles).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        merged.activeProfiles(mergedActiveProfiles);
        List dominantPluginGroupIds = dominant.getPluginGroups();
        List recessivePluginGroupIds = recessive.getPluginGroups();
        List mergedPluginGroupIds = Stream.of(dominantPluginGroupIds, recessivePluginGroupIds).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        merged.pluginGroups(mergedPluginGroupIds);
        String localRepository = StringUtils.isEmpty((String)dominant.getLocalRepository()) ? recessive.getLocalRepository() : dominant.getLocalRepository();
        merged.localRepository(localRepository);
        merged.mirrors(MavenSettingsMerger.shallowMergeById(dominant.getMirrors(), recessive.getMirrors(), recessiveSourceLevel));
        merged.servers(MavenSettingsMerger.shallowMergeById(dominant.getServers(), recessive.getServers(), recessiveSourceLevel));
        merged.proxies(MavenSettingsMerger.shallowMergeById(dominant.getProxies(), recessive.getProxies(), recessiveSourceLevel));
        merged.profiles(MavenSettingsMerger.shallowMergeById(dominant.getProfiles(), recessive.getProfiles(), recessiveSourceLevel));
        return merged.build();
    }

    private static <T extends IdentifiableBase> List<T> shallowMergeById(List<T> dominant, List<T> recessive, String recessiveSourceLevel) {
        Set dominantIds = dominant.stream().map(IdentifiableBase::getId).collect(Collectors.toSet());
        ArrayList<Object> merged = new ArrayList<Object>(dominant.size() + recessive.size());
        merged.addAll(dominant);
        for (IdentifiableBase identifiable : recessive) {
            if (dominantIds.contains(identifiable.getId())) continue;
            identifiable.setSourceLevel(recessiveSourceLevel);
            merged.add(identifiable);
        }
        return merged;
    }

    private static <T extends IdentifiableBase> Map<String, T> mapById(List<T> identifiables) {
        HashMap<String, IdentifiableBase> byId = new HashMap<String, IdentifiableBase>();
        for (IdentifiableBase identifiable : identifiables) {
            byId.put(identifiable.getId(), identifiable);
        }
        return byId;
    }
}

