/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.xml.Dom;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.internal.xml.Xpp3Dom;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleMappingDelegate;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.MojoExecutionConfigurator;
import org.apache.maven.lifecycle.internal.DefaultMojoExecutionConfigurator;
import org.apache.maven.lifecycle.internal.ExecutionPlanItem;
import org.apache.maven.lifecycle.internal.GoalTask;
import org.apache.maven.lifecycle.internal.LifecycleDependencyResolver;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.lifecycle.internal.LifecyclePluginResolver;
import org.apache.maven.lifecycle.internal.LifecycleTask;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.lifecycle.internal.builder.BuilderCommon;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.lifecycle.Execution;
import org.apache.maven.plugin.lifecycle.Phase;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Named
@Singleton
public class DefaultLifecycleExecutionPlanCalculator
implements LifecycleExecutionPlanCalculator {
    private final BuildPluginManager pluginManager;
    private final DefaultLifecycles defaultLifecycles;
    private final MojoDescriptorCreator mojoDescriptorCreator;
    private final LifecyclePluginResolver lifecyclePluginResolver;
    private final LifecycleMappingDelegate standardDelegate;
    private final Map<String, LifecycleMappingDelegate> delegates;
    private final Map<String, MojoExecutionConfigurator> mojoExecutionConfigurators;

    @Inject
    public DefaultLifecycleExecutionPlanCalculator(BuildPluginManager pluginManager, DefaultLifecycles defaultLifecycles, MojoDescriptorCreator mojoDescriptorCreator, LifecyclePluginResolver lifecyclePluginResolver, @Named(value="default") LifecycleMappingDelegate standardDelegate, Map<String, LifecycleMappingDelegate> delegates, Map<String, MojoExecutionConfigurator> mojoExecutionConfigurators) {
        this.pluginManager = pluginManager;
        this.defaultLifecycles = defaultLifecycles;
        this.mojoDescriptorCreator = mojoDescriptorCreator;
        this.lifecyclePluginResolver = lifecyclePluginResolver;
        this.standardDelegate = standardDelegate;
        this.delegates = delegates;
        this.mojoExecutionConfigurators = mojoExecutionConfigurators;
    }

    public DefaultLifecycleExecutionPlanCalculator(BuildPluginManager pluginManager, DefaultLifecycles defaultLifecycles, MojoDescriptorCreator mojoDescriptorCreator, LifecyclePluginResolver lifecyclePluginResolver) {
        this.pluginManager = pluginManager;
        this.defaultLifecycles = defaultLifecycles;
        this.mojoDescriptorCreator = mojoDescriptorCreator;
        this.lifecyclePluginResolver = lifecyclePluginResolver;
        this.standardDelegate = null;
        this.delegates = null;
        this.mojoExecutionConfigurators = Collections.singletonMap("default", new DefaultMojoExecutionConfigurator());
    }

    @Override
    public MavenExecutionPlan calculateExecutionPlan(MavenSession session, MavenProject project, List<Object> tasks, boolean setup) throws PluginNotFoundException, PluginResolutionException, LifecyclePhaseNotFoundException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecycleNotFoundException, PluginVersionResolutionException {
        this.lifecyclePluginResolver.resolveMissingPluginVersions(project, session);
        List<MojoExecution> executions = this.calculateMojoExecutions(session, project, tasks);
        if (setup) {
            this.setupMojoExecutions(session, project, executions);
        }
        List<ExecutionPlanItem> planItem = ExecutionPlanItem.createExecutionPlanItems(project, executions);
        return new MavenExecutionPlan(planItem, this.defaultLifecycles);
    }

    @Override
    public MavenExecutionPlan calculateExecutionPlan(MavenSession session, MavenProject project, List<Object> tasks) throws PluginNotFoundException, PluginResolutionException, LifecyclePhaseNotFoundException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecycleNotFoundException, PluginVersionResolutionException {
        return this.calculateExecutionPlan(session, project, tasks, true);
    }

    private void setupMojoExecutions(MavenSession session, MavenProject project, List<MojoExecution> mojoExecutions) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        Set<MojoDescriptor> alreadyPlannedExecutions = this.fillMojoDescriptors(session, project, mojoExecutions);
        for (MojoExecution mojoExecution : mojoExecutions) {
            this.setupMojoExecution(session, project, mojoExecution, alreadyPlannedExecutions);
        }
    }

    private Set<MojoDescriptor> fillMojoDescriptors(MavenSession session, MavenProject project, List<MojoExecution> mojoExecutions) throws InvalidPluginDescriptorException, MojoNotFoundException, PluginResolutionException, PluginDescriptorParsingException, PluginNotFoundException {
        HashSet<MojoDescriptor> descriptors = new HashSet<MojoDescriptor>(mojoExecutions.size());
        for (MojoExecution execution : mojoExecutions) {
            MojoDescriptor mojoDescriptor = this.fillMojoDescriptor(session, project, execution);
            descriptors.add(mojoDescriptor);
        }
        return descriptors;
    }

    private MojoDescriptor fillMojoDescriptor(MavenSession session, MavenProject project, MojoExecution execution) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException {
        MojoDescriptor mojoDescriptor = execution.getMojoDescriptor();
        if (mojoDescriptor == null) {
            mojoDescriptor = this.pluginManager.getMojoDescriptor(execution.getPlugin(), execution.getGoal(), project.getRemotePluginRepositories(), session.getRepositorySession());
            execution.setMojoDescriptor(mojoDescriptor);
        }
        return mojoDescriptor;
    }

    @Override
    public void setupMojoExecution(MavenSession session, MavenProject project, MojoExecution mojoExecution, Set<MojoDescriptor> alreadyPlannedExecutions) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException, NoPluginFoundForPrefixException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        this.fillMojoDescriptor(session, project, mojoExecution);
        this.mojoExecutionConfigurator(mojoExecution).configure(project, mojoExecution, MojoExecution.Source.CLI.equals((Object)mojoExecution.getSource()));
        this.finalizeMojoConfiguration(mojoExecution);
        this.calculateForkedExecutions(mojoExecution, session, project, alreadyPlannedExecutions);
    }

    public List<MojoExecution> calculateMojoExecutions(MavenSession session, MavenProject project, List<Object> tasks) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException, LifecyclePhaseNotFoundException {
        ArrayList<MojoExecution> mojoExecutions = new ArrayList<MojoExecution>();
        for (Object task : tasks) {
            if (task instanceof GoalTask) {
                String pluginGoal = ((GoalTask)task).pluginGoal;
                String executionId = "default-cli";
                int executionIdx = pluginGoal.indexOf(64);
                if (executionIdx > 0) {
                    executionId = pluginGoal.substring(executionIdx + 1);
                }
                MojoDescriptor mojoDescriptor = this.mojoDescriptorCreator.getMojoDescriptor(pluginGoal, session, project);
                MojoExecution mojoExecution = new MojoExecution(mojoDescriptor, executionId, MojoExecution.Source.CLI);
                mojoExecutions.add(mojoExecution);
                continue;
            }
            if (task instanceof LifecycleTask) {
                String lifecyclePhase = ((LifecycleTask)task).getLifecyclePhase();
                Map<String, List<MojoExecution>> phaseToMojoMapping = this.calculateLifecycleMappings(session, project, lifecyclePhase);
                for (List<MojoExecution> mojoExecutionsFromLifecycle : phaseToMojoMapping.values()) {
                    mojoExecutions.addAll(mojoExecutionsFromLifecycle);
                }
                continue;
            }
            throw new IllegalStateException("unexpected task " + task);
        }
        return mojoExecutions;
    }

    private Map<String, List<MojoExecution>> calculateLifecycleMappings(MavenSession session, MavenProject project, String lifecyclePhase) throws LifecyclePhaseNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException {
        LifecycleMappingDelegate delegate;
        Lifecycle lifecycle = this.defaultLifecycles.get(lifecyclePhase);
        if (lifecycle == null) {
            throw new LifecyclePhaseNotFoundException("Unknown lifecycle phase \"" + lifecyclePhase + "\". You must specify a valid lifecycle phase or a goal in the format <plugin-prefix>:<goal> or <plugin-group-id>:<plugin-artifact-id>[:<plugin-version>]:<goal>. Available lifecycle phases are: " + this.defaultLifecycles.getLifecyclePhaseList() + ".", lifecyclePhase);
        }
        if (Arrays.binarySearch(DefaultLifecycles.STANDARD_LIFECYCLES, lifecycle.getId()) >= 0) {
            delegate = this.standardDelegate;
        } else {
            delegate = this.delegates.get(lifecycle.getId());
            if (delegate == null) {
                delegate = this.standardDelegate;
            }
        }
        return delegate.calculateLifecycleMappings(session, project, lifecycle, lifecyclePhase);
    }

    private void finalizeMojoConfiguration(MojoExecution mojoExecution) {
        Dom executionConfiguration;
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        org.codehaus.plexus.util.xml.Xpp3Dom config = mojoExecution.getConfiguration();
        Dom dom = executionConfiguration = config != null ? config.getDom() : null;
        if (executionConfiguration == null) {
            executionConfiguration = new Xpp3Dom("configuration");
        }
        Dom defaultConfiguration = this.getMojoConfiguration(mojoDescriptor);
        ArrayList<Dom> children = new ArrayList<Dom>();
        if (mojoDescriptor.getParameters() != null) {
            for (Parameter parameter : mojoDescriptor.getParameters()) {
                Dom parameterConfiguration = executionConfiguration.getChild(parameter.getName());
                if (parameterConfiguration == null) {
                    parameterConfiguration = executionConfiguration.getChild(parameter.getAlias());
                }
                Dom parameterDefaults = defaultConfiguration.getChild(parameter.getName());
                if ((parameterConfiguration = parameterConfiguration != null ? parameterConfiguration.merge(parameterDefaults, Boolean.TRUE) : parameterDefaults) == null) continue;
                HashMap<String, String> attributes = new HashMap<String, String>(parameterConfiguration.getAttributes());
                if (StringUtils.isEmpty((String)parameterConfiguration.getAttribute("implementation")) && StringUtils.isNotEmpty((String)parameter.getImplementation())) {
                    attributes.put("implementation", parameter.getImplementation());
                }
                parameterConfiguration = new Xpp3Dom(parameter.getName(), parameterConfiguration.getValue(), attributes, parameterConfiguration.getChildren(), parameterConfiguration.getInputLocation());
                children.add(parameterConfiguration);
            }
        }
        Xpp3Dom finalConfiguration = new Xpp3Dom("configuration", null, null, children, null);
        mojoExecution.setConfiguration((Dom)finalConfiguration);
    }

    private Dom getMojoConfiguration(MojoDescriptor mojoDescriptor) {
        return MojoDescriptorCreator.convert(mojoDescriptor).getDom();
    }

    @Override
    public void calculateForkedExecutions(MojoExecution mojoExecution, MavenSession session) throws MojoNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        this.calculateForkedExecutions(mojoExecution, session, session.getCurrentProject(), new HashSet<MojoDescriptor>());
    }

    private void calculateForkedExecutions(MojoExecution mojoExecution, MavenSession session, MavenProject project, Collection<MojoDescriptor> alreadyPlannedExecutions) throws MojoNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        if (!mojoDescriptor.isForking()) {
            return;
        }
        alreadyPlannedExecutions.add(mojoDescriptor);
        List<MavenProject> forkedProjects = LifecycleDependencyResolver.getProjects(project, session, mojoDescriptor.isAggregator());
        for (MavenProject forkedProject : forkedProjects) {
            List<MojoExecution> forkedExecutions;
            if (forkedProject != project) {
                this.lifecyclePluginResolver.resolveMissingPluginVersions(forkedProject, session);
            }
            if ((forkedExecutions = StringUtils.isNotEmpty((String)mojoDescriptor.getExecutePhase()) ? this.calculateForkedLifecycle(mojoExecution, session, forkedProject, alreadyPlannedExecutions) : this.calculateForkedGoal(mojoExecution, session, forkedProject, alreadyPlannedExecutions)).isEmpty()) continue;
            mojoExecution.setForkedExecutions(BuilderCommon.getKey(forkedProject), forkedExecutions);
        }
    }

    private List<MojoExecution> calculateForkedLifecycle(MojoExecution mojoExecution, MavenSession session, MavenProject project, Collection<MojoDescriptor> alreadyPlannedExecutions) throws MojoNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        String forkedPhase = mojoDescriptor.getExecutePhase();
        Map<String, List<MojoExecution>> lifecycleMappings = this.calculateLifecycleMappings(session, project, forkedPhase);
        for (List<MojoExecution> forkedExecutions : lifecycleMappings.values()) {
            for (MojoExecution forkedExecution : forkedExecutions) {
                if (forkedExecution.getMojoDescriptor() == null) {
                    MojoDescriptor forkedMojoDescriptor = this.pluginManager.getMojoDescriptor(forkedExecution.getPlugin(), forkedExecution.getGoal(), project.getRemotePluginRepositories(), session.getRepositorySession());
                    forkedExecution.setMojoDescriptor(forkedMojoDescriptor);
                }
                this.mojoExecutionConfigurator(forkedExecution).configure(project, forkedExecution, false);
            }
        }
        this.injectLifecycleOverlay(lifecycleMappings, mojoExecution, session, project);
        ArrayList<MojoExecution> mojoExecutions = new ArrayList<MojoExecution>();
        for (List<MojoExecution> forkedExecutions : lifecycleMappings.values()) {
            for (MojoExecution forkedExecution : forkedExecutions) {
                if (alreadyPlannedExecutions.contains(forkedExecution.getMojoDescriptor())) continue;
                this.finalizeMojoConfiguration(forkedExecution);
                this.calculateForkedExecutions(forkedExecution, session, project, alreadyPlannedExecutions);
                mojoExecutions.add(forkedExecution);
            }
        }
        return mojoExecutions;
    }

    private void injectLifecycleOverlay(Map<String, List<MojoExecution>> lifecycleMappings, MojoExecution mojoExecution, MavenSession session, MavenProject project) throws PluginDescriptorParsingException, LifecycleNotFoundException, MojoNotFoundException, PluginNotFoundException, PluginResolutionException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException {
        org.apache.maven.plugin.lifecycle.Lifecycle lifecycleOverlay;
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
        String forkedLifecycle = mojoDescriptor.getExecuteLifecycle();
        if (StringUtils.isEmpty((String)forkedLifecycle)) {
            return;
        }
        try {
            lifecycleOverlay = pluginDescriptor.getLifecycleMapping(forkedLifecycle);
        }
        catch (IOException | XmlPullParserException e) {
            throw new PluginDescriptorParsingException(pluginDescriptor.getPlugin(), pluginDescriptor.getSource(), e);
        }
        if (lifecycleOverlay == null) {
            throw new LifecycleNotFoundException(forkedLifecycle);
        }
        for (Phase phase : lifecycleOverlay.getPhases()) {
            List<MojoExecution> forkedExecutions = lifecycleMappings.get(phase.getId());
            if (forkedExecutions == null) continue;
            for (Execution execution : phase.getExecutions()) {
                for (String goal : execution.getGoals()) {
                    MojoDescriptor forkedMojoDescriptor;
                    if (goal.indexOf(58) < 0) {
                        forkedMojoDescriptor = pluginDescriptor.getMojo(goal);
                        if (forkedMojoDescriptor == null) {
                            throw new MojoNotFoundException(goal, pluginDescriptor);
                        }
                    } else {
                        forkedMojoDescriptor = this.mojoDescriptorCreator.getMojoDescriptor(goal, session, project);
                    }
                    MojoExecution forkedExecution = new MojoExecution(forkedMojoDescriptor, mojoExecution.getExecutionId());
                    Xpp3Dom forkedConfiguration = (Xpp3Dom)execution.getConfiguration();
                    forkedExecution.setConfiguration((Dom)forkedConfiguration);
                    this.mojoExecutionConfigurator(forkedExecution).configure(project, forkedExecution, true);
                    forkedExecutions.add(forkedExecution);
                }
            }
            Xpp3Dom phaseConfiguration = (Xpp3Dom)phase.getConfiguration();
            if (phaseConfiguration == null) continue;
            for (MojoExecution forkedExecution : forkedExecutions) {
                org.codehaus.plexus.util.xml.Xpp3Dom config = forkedExecution.getConfiguration();
                if (config == null) continue;
                Dom forkedConfiguration = config.getDom();
                forkedConfiguration = phaseConfiguration.merge(forkedConfiguration);
                forkedExecution.setConfiguration(forkedConfiguration);
            }
        }
    }

    private List<MojoExecution> calculateForkedGoal(MojoExecution mojoExecution, MavenSession session, MavenProject project, Collection<MojoDescriptor> alreadyPlannedExecutions) throws MojoNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        String forkedGoal;
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
        MojoDescriptor forkedMojoDescriptor = pluginDescriptor.getMojo(forkedGoal = mojoDescriptor.getExecuteGoal());
        if (forkedMojoDescriptor == null) {
            throw new MojoNotFoundException(forkedGoal, pluginDescriptor);
        }
        if (alreadyPlannedExecutions.contains(forkedMojoDescriptor)) {
            return Collections.emptyList();
        }
        MojoExecution forkedExecution = new MojoExecution(forkedMojoDescriptor, forkedGoal);
        this.mojoExecutionConfigurator(forkedExecution).configure(project, forkedExecution, true);
        this.finalizeMojoConfiguration(forkedExecution);
        this.calculateForkedExecutions(forkedExecution, session, project, alreadyPlannedExecutions);
        return Collections.singletonList(forkedExecution);
    }

    private MojoExecutionConfigurator mojoExecutionConfigurator(MojoExecution mojoExecution) {
        MojoExecutionConfigurator mojoExecutionConfigurator;
        String configuratorId = mojoExecution.getMojoDescriptor().getComponentConfigurator();
        if (configuratorId == null) {
            configuratorId = "default";
        }
        if ((mojoExecutionConfigurator = this.mojoExecutionConfigurators.get(configuratorId)) == null) {
            mojoExecutionConfigurator = this.mojoExecutionConfigurators.get("default");
        }
        return mojoExecutionConfigurator;
    }
}

