/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.BuilderProblem;
import org.apache.maven.api.services.SettingsBuilder;
import org.apache.maven.api.services.SettingsBuilderException;
import org.apache.maven.api.services.SettingsBuilderRequest;
import org.apache.maven.api.services.SettingsBuilderResult;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.settings.Settings;
import org.apache.maven.internal.impl.DefaultSession;
import org.apache.maven.internal.impl.MappedList;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.building.SettingsSource;

@Named
@Singleton
public class DefaultSettingsBuilder
implements SettingsBuilder {
    private final org.apache.maven.settings.building.SettingsBuilder builder;

    @Inject
    public DefaultSettingsBuilder(org.apache.maven.settings.building.SettingsBuilder builder) {
        this.builder = builder;
    }

    @Nonnull
    public SettingsBuilderResult build(SettingsBuilderRequest request) throws SettingsBuilderException, IllegalArgumentException {
        DefaultSession session = (DefaultSession)request.getSession();
        try {
            DefaultSettingsBuildingRequest req = new DefaultSettingsBuildingRequest();
            req.setUserProperties(this.toProperties(session.getUserProperties()));
            req.setSystemProperties(this.toProperties(session.getSystemProperties()));
            if (request.getGlobalSettingsSource().isPresent()) {
                req.setGlobalSettingsSource((SettingsSource)new MappedSettingsSource((Source)request.getGlobalSettingsSource().get()));
            }
            if (request.getGlobalSettingsPath().isPresent()) {
                req.setGlobalSettingsFile(((Path)request.getGlobalSettingsPath().get()).toFile());
            }
            if (request.getUserSettingsSource().isPresent()) {
                req.setUserSettingsSource((SettingsSource)new MappedSettingsSource((Source)request.getUserSettingsSource().get()));
            }
            if (request.getUserSettingsPath().isPresent()) {
                req.setUserSettingsFile(((Path)request.getUserSettingsPath().get()).toFile());
            }
            final SettingsBuildingResult result = this.builder.build((SettingsBuildingRequest)req);
            return new SettingsBuilderResult(){

                public Settings getEffectiveSettings() {
                    return result.getEffectiveSettings().getDelegate();
                }

                public List<BuilderProblem> getProblems() {
                    return new MappedList<BuilderProblem, SettingsProblem>(result.getProblems(), MappedBuilderProblem::new);
                }
            };
        }
        catch (SettingsBuildingException e) {
            throw new SettingsBuilderException("Unable to build settings", (Exception)((Object)e));
        }
    }

    private Properties toProperties(Map<String, String> map) {
        Properties properties = new Properties();
        properties.putAll(map);
        return properties;
    }

    private static class MappedBuilderProblem
    implements BuilderProblem {
        private final SettingsProblem problem;

        MappedBuilderProblem(SettingsProblem problem) {
            this.problem = problem;
        }

        public String getSource() {
            return this.problem.getSource();
        }

        public int getLineNumber() {
            return this.problem.getLineNumber();
        }

        public int getColumnNumber() {
            return this.problem.getColumnNumber();
        }

        public String getLocation() {
            return this.problem.getLocation();
        }

        public Exception getException() {
            return this.problem.getException();
        }

        public String getMessage() {
            return this.problem.getMessage();
        }

        public BuilderProblem.Severity getSeverity() {
            return BuilderProblem.Severity.valueOf((String)this.problem.getSeverity().name());
        }
    }

    private static class MappedSettingsSource
    implements SettingsSource {
        private final Source source;

        MappedSettingsSource(Source source) {
            this.source = source;
        }

        public InputStream getInputStream() throws IOException {
            return this.source.getInputStream();
        }

        public String getLocation() {
            return this.source.getLocation();
        }
    }
}

