/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.Listener;
import org.apache.maven.api.LocalRepository;
import org.apache.maven.api.Node;
import org.apache.maven.api.Project;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.Version;
import org.apache.maven.api.VersionRange;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.services.ArtifactCoordinateFactory;
import org.apache.maven.api.services.ArtifactDeployer;
import org.apache.maven.api.services.ArtifactFactory;
import org.apache.maven.api.services.ArtifactInstaller;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.ArtifactResolver;
import org.apache.maven.api.services.DependencyCollector;
import org.apache.maven.api.services.DependencyCoordinateFactory;
import org.apache.maven.api.services.LocalRepositoryManager;
import org.apache.maven.api.services.RepositoryFactory;
import org.apache.maven.api.services.VersionParser;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.internal.impl.DefaultArtifact;
import org.apache.maven.internal.impl.DefaultArtifactCoordinate;
import org.apache.maven.internal.impl.DefaultDependency;
import org.apache.maven.internal.impl.DefaultLocalRepository;
import org.apache.maven.internal.impl.DefaultNode;
import org.apache.maven.internal.impl.DefaultProject;
import org.apache.maven.internal.impl.DefaultRemoteRepository;
import org.apache.maven.internal.impl.Utils;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public abstract class AbstractSession
implements Session {
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final Map<DependencyNode, Node> allNodes = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Artifact, org.apache.maven.api.Artifact> allArtifacts = Collections.synchronizedMap(new WeakHashMap());
    private final Map<org.eclipse.aether.repository.RemoteRepository, RemoteRepository> allRepositories = Collections.synchronizedMap(new WeakHashMap());
    private final Map<String, Project> allProjects = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Dependency, org.apache.maven.api.Dependency> allDependencies = Collections.synchronizedMap(new WeakHashMap());

    public RemoteRepository getRemoteRepository(org.eclipse.aether.repository.RemoteRepository repository) {
        return this.allRepositories.computeIfAbsent(repository, DefaultRemoteRepository::new);
    }

    public Node getNode(DependencyNode node) {
        return this.getNode(node, false);
    }

    public Node getNode(DependencyNode node, boolean verbose) {
        return this.allNodes.computeIfAbsent(node, n -> new DefaultNode(this, (DependencyNode)n, verbose));
    }

    @Nonnull
    public org.apache.maven.api.Artifact getArtifact(@Nonnull Artifact artifact) {
        return this.allArtifacts.computeIfAbsent(artifact, a -> new DefaultArtifact(this, (Artifact)a));
    }

    @Nonnull
    public org.apache.maven.api.Dependency getDependency(@Nonnull Dependency dependency) {
        return this.allDependencies.computeIfAbsent(dependency, d -> new DefaultDependency(this, (Dependency)d));
    }

    public List<Project> getProjects(List<MavenProject> projects) {
        return projects == null ? null : projects.stream().map(this::getProject).collect(Collectors.toList());
    }

    public Project getProject(MavenProject project) {
        return this.allProjects.computeIfAbsent(project.getId(), id -> new DefaultProject(this, project));
    }

    public List<org.eclipse.aether.repository.RemoteRepository> toRepositories(List<RemoteRepository> repositories) {
        return repositories == null ? null : repositories.stream().map(this::toRepository).collect(Collectors.toList());
    }

    public org.eclipse.aether.repository.RemoteRepository toRepository(RemoteRepository repository) {
        if (repository instanceof DefaultRemoteRepository) {
            return ((DefaultRemoteRepository)repository).getRepository();
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public org.eclipse.aether.repository.LocalRepository toRepository(LocalRepository repository) {
        if (repository instanceof DefaultLocalRepository) {
            return ((DefaultLocalRepository)repository).getRepository();
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public List<ArtifactRepository> toArtifactRepositories(List<RemoteRepository> repositories) {
        return repositories == null ? null : repositories.stream().map(this::toArtifactRepository).collect(Collectors.toList());
    }

    public abstract ArtifactRepository toArtifactRepository(RemoteRepository var1);

    public List<Dependency> toDependencies(Collection<DependencyCoordinate> dependencies) {
        return dependencies == null ? null : dependencies.stream().map(this::toDependency).collect(Collectors.toList());
    }

    public abstract Dependency toDependency(DependencyCoordinate var1);

    public List<Artifact> toArtifacts(Collection<org.apache.maven.api.Artifact> artifacts) {
        return artifacts == null ? null : artifacts.stream().map(this::toArtifact).collect(Collectors.toList());
    }

    public Artifact toArtifact(org.apache.maven.api.Artifact artifact) {
        Artifact a;
        File file = ((ArtifactManager)this.getService(ArtifactManager.class)).getPath(artifact).map(Path::toFile).orElse(null);
        if (artifact instanceof DefaultArtifact && Objects.equals(file, (a = ((DefaultArtifact)artifact).getArtifact()).getFile())) {
            return a;
        }
        return new org.eclipse.aether.artifact.DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getVersion().toString(), null, file);
    }

    public Artifact toArtifact(ArtifactCoordinate coord) {
        if (coord instanceof DefaultArtifactCoordinate) {
            return ((DefaultArtifactCoordinate)coord).getCoordinate();
        }
        return new org.eclipse.aether.artifact.DefaultArtifact(coord.getGroupId(), coord.getArtifactId(), coord.getClassifier(), coord.getExtension(), coord.getVersion().toString(), null, (File)null);
    }

    public void registerListener(@Nonnull Listener listener) {
        this.listeners.add(Utils.nonNull(listener));
    }

    public void unregisterListener(@Nonnull Listener listener) {
        this.listeners.remove(Utils.nonNull(listener));
    }

    @Nonnull
    public Collection<Listener> getListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public LocalRepository createLocalRepository(Path path) {
        return ((RepositoryFactory)this.getService(RepositoryFactory.class)).createLocal(path);
    }

    @Nonnull
    public RemoteRepository createRemoteRepository(@Nonnull String id, @Nonnull String url) {
        return ((RepositoryFactory)this.getService(RepositoryFactory.class)).createRemote(id, url);
    }

    @Nonnull
    public RemoteRepository createRemoteRepository(@Nonnull Repository repository) {
        return ((RepositoryFactory)this.getService(RepositoryFactory.class)).createRemote(repository);
    }

    public ArtifactCoordinate createArtifactCoordinate(String groupId, String artifactId, String version, String extension) {
        return ((ArtifactCoordinateFactory)this.getService(ArtifactCoordinateFactory.class)).create((Session)this, groupId, artifactId, version, extension);
    }

    public ArtifactCoordinate createArtifactCoordinate(String groupId, String artifactId, String version, String classifier, String extension, String type) {
        return ((ArtifactCoordinateFactory)this.getService(ArtifactCoordinateFactory.class)).create((Session)this, groupId, artifactId, version, classifier, extension, type);
    }

    public ArtifactCoordinate createArtifactCoordinate(org.apache.maven.api.Artifact artifact) {
        return ((ArtifactCoordinateFactory)this.getService(ArtifactCoordinateFactory.class)).create((Session)this, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion().asString(), artifact.getClassifier(), artifact.getExtension(), null);
    }

    public org.apache.maven.api.Artifact createArtifact(String groupId, String artifactId, String version, String extension) {
        return ((ArtifactFactory)this.getService(ArtifactFactory.class)).create((Session)this, groupId, artifactId, version, extension);
    }

    public org.apache.maven.api.Artifact createArtifact(String groupId, String artifactId, String version, String classifier, String extension, String type) {
        return ((ArtifactFactory)this.getService(ArtifactFactory.class)).create((Session)this, groupId, artifactId, version, classifier, extension, type);
    }

    public org.apache.maven.api.Artifact resolveArtifact(ArtifactCoordinate coordinate) {
        return (org.apache.maven.api.Artifact)((ArtifactResolver)this.getService(ArtifactResolver.class)).resolve((Session)this, Collections.singletonList(coordinate)).getArtifacts().keySet().iterator().next();
    }

    public Collection<org.apache.maven.api.Artifact> resolveArtifacts(ArtifactCoordinate ... coordinates) {
        return this.resolveArtifacts(Arrays.asList(coordinates));
    }

    public Collection<org.apache.maven.api.Artifact> resolveArtifacts(Collection<? extends ArtifactCoordinate> coordinates) {
        return ((ArtifactResolver)this.getService(ArtifactResolver.class)).resolve((Session)this, coordinates).getArtifacts().keySet();
    }

    public org.apache.maven.api.Artifact resolveArtifact(org.apache.maven.api.Artifact artifact) {
        ArtifactCoordinate coordinate = ((ArtifactCoordinateFactory)this.getService(ArtifactCoordinateFactory.class)).create((Session)this, artifact);
        return this.resolveArtifact(coordinate);
    }

    public Collection<org.apache.maven.api.Artifact> resolveArtifacts(org.apache.maven.api.Artifact ... artifacts) {
        ArtifactCoordinateFactory acf = (ArtifactCoordinateFactory)this.getService(ArtifactCoordinateFactory.class);
        ArtifactCoordinate[] coords = (ArtifactCoordinate[])Stream.of(artifacts).map(a -> acf.create((Session)this, a)).toArray(ArtifactCoordinate[]::new);
        return this.resolveArtifacts(coords);
    }

    public void installArtifacts(org.apache.maven.api.Artifact ... artifacts) {
        this.installArtifacts(Arrays.asList(artifacts));
    }

    public void installArtifacts(Collection<org.apache.maven.api.Artifact> artifacts) {
        ((ArtifactInstaller)this.getService(ArtifactInstaller.class)).install((Session)this, artifacts);
    }

    public void deployArtifact(RemoteRepository repository, org.apache.maven.api.Artifact ... artifacts) {
        ((ArtifactDeployer)this.getService(ArtifactDeployer.class)).deploy((Session)this, repository, Arrays.asList(artifacts));
    }

    public void setArtifactPath(@Nonnull org.apache.maven.api.Artifact artifact, @Nonnull Path path) {
        ((ArtifactManager)this.getService(ArtifactManager.class)).setPath(artifact, path);
    }

    @Nonnull
    public Optional<Path> getArtifactPath(@Nonnull org.apache.maven.api.Artifact artifact) {
        return ((ArtifactManager)this.getService(ArtifactManager.class)).getPath(artifact);
    }

    public boolean isVersionSnapshot(@Nonnull String version) {
        return ((VersionParser)this.getService(VersionParser.class)).isSnapshot(version);
    }

    @Nonnull
    public DependencyCoordinate createDependencyCoordinate(@Nonnull ArtifactCoordinate coordinate) {
        return ((DependencyCoordinateFactory)this.getService(DependencyCoordinateFactory.class)).create((Session)this, coordinate);
    }

    @Nonnull
    public DependencyCoordinate createDependencyCoordinate(@Nonnull org.apache.maven.api.Dependency dependency) {
        return ((DependencyCoordinateFactory)this.getService(DependencyCoordinateFactory.class)).create((Session)this, dependency);
    }

    @Nonnull
    public Node collectDependencies(@Nonnull org.apache.maven.api.Artifact artifact) {
        return ((DependencyCollector)this.getService(DependencyCollector.class)).collect((Session)this, artifact).getRoot();
    }

    @Nonnull
    public Node collectDependencies(@Nonnull Project project) {
        return ((DependencyCollector)this.getService(DependencyCollector.class)).collect((Session)this, project).getRoot();
    }

    @Nonnull
    public Node collectDependencies(@Nonnull DependencyCoordinate dependency) {
        return ((DependencyCollector)this.getService(DependencyCollector.class)).collect((Session)this, dependency).getRoot();
    }

    public Path getPathForLocalArtifact(@Nonnull org.apache.maven.api.Artifact artifact) {
        return ((LocalRepositoryManager)this.getService(LocalRepositoryManager.class)).getPathForLocalArtifact((Session)this, this.getLocalRepository(), artifact);
    }

    public Path getPathForRemoteArtifact(RemoteRepository remote, org.apache.maven.api.Artifact artifact) {
        return ((LocalRepositoryManager)this.getService(LocalRepositoryManager.class)).getPathForRemoteArtifact((Session)this, this.getLocalRepository(), remote, artifact);
    }

    public Version parseVersion(String version) {
        return ((VersionParser)this.getService(VersionParser.class)).parseVersion(version);
    }

    public VersionRange parseVersionRange(String versionRange) {
        return ((VersionParser)this.getService(VersionParser.class)).parseVersionRange(versionRange);
    }
}

