/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.toolchain;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.toolchain.ImmutableCollections;
import org.apache.maven.api.toolchain.ToolchainModel;
import org.apache.maven.api.toolchain.TrackableBase;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class PersistedToolchains
extends TrackableBase
implements Serializable {
    final String modelEncoding;
    final List<ToolchainModel> toolchains;

    PersistedToolchains(String modelEncoding, Collection<ToolchainModel> toolchains) {
        this.modelEncoding = modelEncoding;
        this.toolchains = ImmutableCollections.copy(toolchains);
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    @Nonnull
    public List<ToolchainModel> getToolchains() {
        return this.toolchains;
    }

    @Override
    @Nonnull
    public Builder with() {
        return PersistedToolchains.newBuilder(this);
    }

    @Nonnull
    public PersistedToolchains withToolchains(Collection<ToolchainModel> toolchains) {
        return this.with().toolchains(toolchains).build();
    }

    @Nonnull
    public static PersistedToolchains newInstance() {
        return PersistedToolchains.newInstance(true);
    }

    @Nonnull
    public static PersistedToolchains newInstance(boolean withDefaults) {
        return PersistedToolchains.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return PersistedToolchains.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(PersistedToolchains from) {
        return PersistedToolchains.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(PersistedToolchains from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends TrackableBase.Builder {
        PersistedToolchains base;
        String modelEncoding;
        Collection<ToolchainModel> toolchains;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(PersistedToolchains base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.toolchains = base.toolchains;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder toolchains(Collection<ToolchainModel> toolchains) {
            this.toolchains = toolchains;
            return this;
        }

        @Override
        @Nonnull
        public PersistedToolchains build() {
            if (this.base != null && (this.toolchains == null || this.toolchains == this.base.toolchains)) {
                return this.base;
            }
            return new PersistedToolchains(this.modelEncoding != null ? this.modelEncoding : (this.base != null ? this.base.modelEncoding : "UTF-8"), this.toolchains != null ? this.toolchains : (this.base != null ? this.base.toolchains : null));
        }
    }
}

