/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.lifecycle;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.xml.Dom;
import org.apache.maven.plugin.lifecycle.ImmutableCollections;

@Generated
@ThreadSafe
@Immutable
public class Execution
implements Serializable {
    final Dom configuration;
    final List<String> goals;

    Execution(Dom configuration, Collection<String> goals) {
        this.configuration = configuration;
        this.goals = ImmutableCollections.copy(goals);
    }

    public Dom getConfiguration() {
        return this.configuration;
    }

    @Nonnull
    public List<String> getGoals() {
        return this.goals;
    }

    @Nonnull
    public Builder with() {
        return Execution.newBuilder(this);
    }

    @Nonnull
    public Execution withConfiguration(Dom configuration) {
        return this.with().configuration(configuration).build();
    }

    @Nonnull
    public Execution withGoals(Collection<String> goals) {
        return this.with().goals(goals).build();
    }

    @Nonnull
    public static Execution newInstance() {
        return Execution.newInstance(true);
    }

    @Nonnull
    public static Execution newInstance(boolean withDefaults) {
        return Execution.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Execution.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Execution from) {
        return Execution.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Execution from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Execution base;
        Dom configuration;
        Collection<String> goals;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Execution base, boolean forceCopy) {
            if (forceCopy) {
                this.configuration = base.configuration;
                this.goals = base.goals;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder configuration(Dom configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder goals(Collection<String> goals) {
            this.goals = goals;
            return this;
        }

        @Nonnull
        public Execution build() {
            if (!(this.base == null || this.configuration != null && this.configuration != this.base.configuration || this.goals != null && this.goals != this.base.goals)) {
                return this.base;
            }
            return new Execution((Dom)(this.configuration != null ? this.configuration : (this.base != null ? this.base.configuration : null)), this.goals != null ? this.goals : (this.base != null ? this.base.goals : null));
        }
    }
}

