/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.api.xml.Dom;
import org.apache.maven.internal.xml.Xpp3Dom;
import org.apache.maven.internal.xml.Xpp3DomBuilder;
import org.apache.maven.project.ExtensionDescriptor;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ExtensionDescriptorBuilder {
    public String getExtensionDescriptorLocation() {
        return "META-INF/maven/extension.xml";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExtensionDescriptor build(File extensionJar) throws IOException {
        ExtensionDescriptor extensionDescriptor = null;
        if (extensionJar.isFile()) {
            try (JarFile pluginJar = new JarFile(extensionJar, false);){
                ZipEntry pluginDescriptorEntry = pluginJar.getEntry(this.getExtensionDescriptorLocation());
                if (pluginDescriptorEntry == null) return extensionDescriptor;
                try (InputStream is = pluginJar.getInputStream(pluginDescriptorEntry);){
                    extensionDescriptor = this.build(is);
                    return extensionDescriptor;
                }
            }
        }
        File pluginXml = new File(extensionJar, this.getExtensionDescriptorLocation());
        if (!pluginXml.canRead()) return extensionDescriptor;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(pluginXml));){
            extensionDescriptor = this.build(is);
            return extensionDescriptor;
        }
    }

    public ExtensionDescriptor build(InputStream is) throws IOException {
        Xpp3Dom dom;
        ExtensionDescriptor extensionDescriptor = new ExtensionDescriptor();
        try {
            dom = Xpp3DomBuilder.build((Reader)ReaderFactory.newXmlReader((InputStream)is));
        }
        catch (XmlPullParserException e) {
            throw new IOException(e.getMessage(), e);
        }
        if (!"extension".equals(dom.getName())) {
            throw new IOException("Unexpected root element \"" + dom.getName() + "\", expected \"extension\"");
        }
        extensionDescriptor.setExportedPackages(this.parseStrings(dom.getChild("exportedPackages")));
        extensionDescriptor.setExportedArtifacts(this.parseStrings(dom.getChild("exportedArtifacts")));
        return extensionDescriptor;
    }

    private List<String> parseStrings(Dom dom) {
        ArrayList<String> strings = null;
        if (dom != null) {
            strings = new ArrayList<String>();
            for (Dom child : dom.getChildren()) {
                String string = child.getValue();
                if (string == null || (string = string.trim()).length() <= 0) continue;
                strings.add(string);
            }
        }
        return strings;
    }
}

