/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api;

import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.DependencyCoordinate;
import org.apache.maven.api.Listener;
import org.apache.maven.api.LocalRepository;
import org.apache.maven.api.Node;
import org.apache.maven.api.Project;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Service;
import org.apache.maven.api.SessionData;
import org.apache.maven.api.Version;
import org.apache.maven.api.VersionRange;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.settings.Settings;

@Experimental
@ThreadSafe
public interface Session {
    @Nonnull
    public Settings getSettings();

    @Nonnull
    public LocalRepository getLocalRepository();

    @Nonnull
    public List<RemoteRepository> getRemoteRepositories();

    @Nonnull
    public SessionData getData();

    @Nonnull
    public Map<String, String> getUserProperties();

    @Nonnull
    public Map<String, String> getSystemProperties();

    @Nonnull
    public String getMavenVersion();

    public int getDegreeOfConcurrency();

    @Nonnull
    public Instant getStartTime();

    @Nonnull
    public Path getMultiModuleProjectDirectory();

    @Nonnull
    public Path getExecutionRootDirectory();

    @Nonnull
    public List<Project> getProjects();

    @Nonnull
    public Map<String, Object> getPluginContext(@Nonnull Project var1);

    @Nonnull
    public <T extends Service> T getService(@Nonnull Class<T> var1);

    @Nonnull
    public Session withLocalRepository(@Nonnull LocalRepository var1);

    @Nonnull
    public Session withRemoteRepositories(@Nonnull List<RemoteRepository> var1);

    public void registerListener(@Nonnull Listener var1);

    public void unregisterListener(@Nonnull Listener var1);

    @Nonnull
    public Collection<Listener> getListeners();

    public LocalRepository createLocalRepository(Path var1);

    @Nonnull
    public RemoteRepository createRemoteRepository(@Nonnull String var1, @Nonnull String var2);

    @Nonnull
    public RemoteRepository createRemoteRepository(@Nonnull Repository var1);

    public ArtifactCoordinate createArtifactCoordinate(String var1, String var2, String var3, String var4);

    public ArtifactCoordinate createArtifactCoordinate(String var1, String var2, String var3, String var4, String var5, String var6);

    public ArtifactCoordinate createArtifactCoordinate(Artifact var1);

    @Nonnull
    public DependencyCoordinate createDependencyCoordinate(@Nonnull ArtifactCoordinate var1);

    public Artifact createArtifact(String var1, String var2, String var3, String var4);

    public Artifact createArtifact(String var1, String var2, String var3, String var4, String var5, String var6);

    public Artifact resolveArtifact(ArtifactCoordinate var1);

    public Collection<Artifact> resolveArtifacts(ArtifactCoordinate ... var1);

    public Collection<Artifact> resolveArtifacts(Collection<? extends ArtifactCoordinate> var1);

    public Artifact resolveArtifact(Artifact var1);

    public Collection<Artifact> resolveArtifacts(Artifact ... var1);

    public void installArtifacts(Artifact ... var1);

    public void installArtifacts(Collection<Artifact> var1);

    public void deployArtifact(RemoteRepository var1, Artifact ... var2);

    public void setArtifactPath(@Nonnull Artifact var1, @Nonnull Path var2);

    @Nonnull
    public Optional<Path> getArtifactPath(@Nonnull Artifact var1);

    public boolean isVersionSnapshot(@Nonnull String var1);

    @Nonnull
    public Node collectDependencies(@Nonnull Artifact var1);

    @Nonnull
    public Node collectDependencies(@Nonnull Project var1);

    @Nonnull
    public Node collectDependencies(@Nonnull DependencyCoordinate var1);

    public Path getPathForLocalArtifact(@Nonnull Artifact var1);

    public Path getPathForRemoteArtifact(RemoteRepository var1, Artifact var2);

    @Nonnull
    public Version parseVersion(@Nonnull String var1);

    @Nonnull
    public VersionRange parseVersionRange(@Nonnull String var1);
}

