/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.collector;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.locator.ModelLocator;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.collector.ProjectCollectionStrategy;
import org.apache.maven.project.collector.ProjectsSelector;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="MultiModuleCollectionStrategy")
@Singleton
public class MultiModuleCollectionStrategy
implements ProjectCollectionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiModuleCollectionStrategy.class);
    private final ModelLocator modelLocator;
    private final ProjectsSelector projectsSelector;

    @Inject
    public MultiModuleCollectionStrategy(ModelLocator modelLocator, ProjectsSelector projectsSelector) {
        this.modelLocator = modelLocator;
        this.projectsSelector = projectsSelector;
    }

    @Override
    public List<MavenProject> collectProjects(MavenExecutionRequest request) throws ProjectBuildingException {
        File moduleProjectPomFile = this.getMultiModuleProjectPomFile(request);
        List<File> files = Collections.singletonList(moduleProjectPomFile.getAbsoluteFile());
        try {
            List<MavenProject> projects = this.projectsSelector.selectProjects(files, request);
            boolean isRequestedProjectCollected = this.isRequestedProjectCollected(request, projects);
            if (isRequestedProjectCollected) {
                return projects;
            }
            LOGGER.debug("Multi module project collection failed:{}Detected a POM file next to a .mvn directory in a parent directory ({}). Maven assumed that POM file to be the parent of the requested project ({}), but it turned out that it was not. Another project collection strategy will be executed as result.", new Object[]{System.lineSeparator(), moduleProjectPomFile.getAbsolutePath(), request.getPom().getAbsolutePath()});
            return Collections.emptyList();
        }
        catch (ProjectBuildingException e) {
            boolean fallThrough = this.isModuleOutsideRequestScopeDependingOnPluginModule(request, e);
            if (fallThrough) {
                LOGGER.debug("Multi module project collection failed:{}Detected that one of the modules of this multi-module project uses another module as plugin extension which still needed to be built. This is not possible within the same reactor build. Another project collection strategy will be executed as result.", (Object)System.lineSeparator());
                return Collections.emptyList();
            }
            throw e;
        }
    }

    private File getMultiModuleProjectPomFile(MavenExecutionRequest request) {
        if (request.getPom().getParentFile().equals(request.getMultiModuleProjectDirectory())) {
            return request.getPom();
        }
        File multiModuleProjectPom = this.modelLocator.locatePom(request.getMultiModuleProjectDirectory());
        if (!multiModuleProjectPom.exists()) {
            LOGGER.info("Maven detected that the requested POM file is part of a multi-module project, but could not find a pom.xml file in the multi-module root directory '{}'.", (Object)request.getMultiModuleProjectDirectory());
            LOGGER.info("The reactor is limited to all projects under: " + request.getPom().getParent());
            return request.getPom();
        }
        return multiModuleProjectPom;
    }

    private boolean isRequestedProjectCollected(MavenExecutionRequest request, List<MavenProject> projects) {
        return projects.stream().map(MavenProject::getFile).anyMatch(request.getPom()::equals);
    }

    private boolean isModuleOutsideRequestScopeDependingOnPluginModule(MavenExecutionRequest request, ProjectBuildingException exception) {
        return exception.getResults().stream().map(ProjectBuildingResult::getProject).filter(Objects::nonNull).filter(project -> request.getPom().equals(project.getFile())).findFirst().map(requestPomProject -> {
            List<Object> modules = requestPomProject.getCollectedProjects() != null ? requestPomProject.getCollectedProjects() : Collections.emptyList();
            ArrayList projectsInRequestScope = new ArrayList(modules);
            projectsInRequestScope.add(requestPomProject);
            Predicate<ProjectBuildingResult> projectsOutsideOfRequestScope = pr -> !projectsInRequestScope.contains(pr.getProject());
            Predicate<Exception> pluginArtifactNotFoundException = exc -> exc instanceof PluginManagerException && exc.getCause() instanceof PluginResolutionException && exc.getCause().getCause() instanceof ArtifactResolutionException && exc.getCause().getCause().getCause() instanceof ArtifactNotFoundException;
            Predicate<Plugin> isPluginPartOfRequestScope = plugin -> projectsInRequestScope.stream().anyMatch(project -> project.getGroupId().equals(plugin.getGroupId()) && project.getArtifactId().equals(plugin.getArtifactId()) && project.getVersion().equals(plugin.getVersion()));
            return exception.getResults().stream().filter(projectsOutsideOfRequestScope).flatMap(projectBuildingResult -> projectBuildingResult.getProblems().stream()).map(ModelProblem::getException).filter(pluginArtifactNotFoundException).map(exc -> ((PluginResolutionException)exc.getCause()).getPlugin()).anyMatch(isPluginPartOfRequestScope);
        }).orElse(false);
    }
}

