/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.model.Model;

class ReactorModelPool {
    private final Map<GAKey, Set<Model>> modelsByGa = new HashMap<GAKey, Set<Model>>();
    private final Map<Path, Model> modelsByPath = new HashMap<Path, Model>();

    ReactorModelPool() {
    }

    public Model get(String groupId, String artifactId, String version) {
        return this.modelsByGa.getOrDefault(new GAKey(groupId, artifactId), Collections.emptySet()).stream().filter(m -> version == null || version.equals(this.getVersion((Model)m))).reduce((a, b) -> {
            throw new IllegalStateException("Multiple modules with key " + a.getGroupId() + ':' + a.getArtifactId());
        }).orElse(null);
    }

    public Model get(Path path) {
        Path pomFile = Files.isDirectory(path, new LinkOption[0]) ? path.resolve("pom.xml") : path;
        return this.modelsByPath.get(pomFile);
    }

    private String getVersion(Model model) {
        String version = model.getVersion();
        if (version == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        return version;
    }

    private static final class GAKey {
        private final String groupId;
        private final String artifactId;
        private final int hashCode;

        GAKey(String groupId, String artifactId) {
            this.groupId = groupId != null ? groupId : "";
            this.artifactId = artifactId != null ? artifactId : "";
            this.hashCode = Objects.hash(this.groupId, this.artifactId);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            GAKey that = (GAKey)obj;
            return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(this.groupId).append(':').append(this.artifactId);
            return buffer.toString();
        }
    }

    static class Builder {
        private ReactorModelPool pool = new ReactorModelPool();

        Builder() {
        }

        Builder put(Path pomFile, Model model) {
            this.pool.modelsByPath.put(pomFile, model);
            this.pool.modelsByGa.computeIfAbsent(new GAKey(Builder.getGroupId(model), model.getArtifactId()), k -> new HashSet()).add(model);
            return this;
        }

        ReactorModelPool build() {
            return this.pool;
        }

        private static String getGroupId(Model model) {
            String groupId = model.getGroupId();
            if (groupId == null && model.getParent() != null) {
                groupId = model.getParent().getGroupId();
            }
            return groupId;
        }
    }
}

