/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.collector;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.collector.ProjectsSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultProjectsSelector
implements ProjectsSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProjectsSelector.class);
    private final ProjectBuilder projectBuilder;

    @Inject
    public DefaultProjectsSelector(ProjectBuilder projectBuilder) {
        this.projectBuilder = projectBuilder;
    }

    @Override
    public List<MavenProject> selectProjects(List<File> files, MavenExecutionRequest request) throws ProjectBuildingException {
        ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
        boolean hasProjectSelection = !request.getProjectActivation().isEmpty();
        boolean isRecursive = hasProjectSelection || request.isRecursive();
        List<ProjectBuildingResult> results = this.projectBuilder.build(files, isRecursive, projectBuildingRequest);
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>(results.size());
        boolean problems = false;
        for (ProjectBuildingResult result : results) {
            projects.add(result.getProject());
            if (result.getProblems().isEmpty() || !LOGGER.isWarnEnabled()) continue;
            LOGGER.warn("");
            LOGGER.warn("Some problems were encountered while building the effective model for '{}'", (Object)result.getProject().getId());
            for (ModelProblem problem : result.getProblems()) {
                String loc = ModelProblemUtils.formatLocation((ModelProblem)problem, (String)result.getProjectId());
                LOGGER.warn("{}{}", (Object)problem.getMessage(), (Object)(loc != null && !loc.isEmpty() ? " @ " + loc : ""));
            }
            problems = true;
        }
        if (problems) {
            LOGGER.warn("");
            LOGGER.warn("It is highly recommended to fix these problems because they threaten the stability of your build.");
            LOGGER.warn("");
            LOGGER.warn("For this reason, future Maven versions might no longer support building such malformed projects.");
            LOGGER.warn("");
        }
        return projects;
    }
}

