/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.project.DuplicateArtifactAttachmentException;
import org.apache.maven.project.MavenProject;

public class PluginExecutionException
extends PluginManagerException {
    private final MojoExecution mojoExecution;

    public PluginExecutionException(MojoExecution mojoExecution, MavenProject project, String message) {
        super(mojoExecution.getMojoDescriptor(), project, message);
        this.mojoExecution = mojoExecution;
    }

    public PluginExecutionException(MojoExecution mojoExecution, MavenProject project, String message, Throwable cause) {
        super(mojoExecution.getMojoDescriptor(), project, message, cause);
        this.mojoExecution = mojoExecution;
    }

    public PluginExecutionException(MojoExecution mojoExecution, MavenProject project, Exception cause) {
        super(mojoExecution.getMojoDescriptor(), project, PluginExecutionException.constructMessage(mojoExecution, cause), (Throwable)cause);
        this.mojoExecution = mojoExecution;
    }

    public PluginExecutionException(MojoExecution mojoExecution, MavenProject project, DuplicateArtifactAttachmentException cause) {
        super(mojoExecution.getMojoDescriptor(), project, PluginExecutionException.constructMessage(mojoExecution, cause), (Throwable)cause);
        this.mojoExecution = mojoExecution;
    }

    public MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    private static String constructMessage(MojoExecution mojoExecution, Throwable cause) {
        String message = mojoExecution != null ? "Execution " + mojoExecution.getExecutionId() + " of goal " + mojoExecution.getMojoDescriptor().getId() + " failed" : "Mojo execution failed";
        message = cause != null && cause.getMessage() != null && !cause.getMessage().isEmpty() ? message + ": " + cause.getMessage() : message + ".";
        return message;
    }
}

