/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.io.FileNotFoundException;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.slf4j.Logger;

class LoggingRepositoryListener
extends AbstractRepositoryListener {
    private final Logger logger;

    LoggingRepositoryListener(Logger logger) {
        this.logger = logger;
    }

    public void artifactInstalling(RepositoryEvent event) {
        this.logger.info("Installing {} to {}", (Object)event.getArtifact().getFile(), (Object)event.getFile());
    }

    public void metadataInstalling(RepositoryEvent event) {
        this.logger.debug("Installing {} to {}", (Object)event.getMetadata(), (Object)event.getFile());
    }

    public void metadataResolved(RepositoryEvent event) {
        Exception e = event.getException();
        if (e != null) {
            if (e instanceof MetadataNotFoundException) {
                this.logger.debug(e.getMessage());
            } else if (this.logger.isDebugEnabled()) {
                this.logger.warn(e.getMessage(), (Throwable)e);
            } else {
                this.logger.warn(e.getMessage());
            }
        }
    }

    public void metadataInvalid(RepositoryEvent event) {
        Exception exception = event.getException();
        Object metadata = event.getMetadata().getFile() != null ? event.getMetadata().getFile() : event.getMetadata();
        String errorType = " is invalid";
        if (exception instanceof FileNotFoundException) {
            errorType = " is inaccessible";
        }
        String msg = "";
        if (exception != null) {
            msg = ": " + exception.getMessage();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.warn("The metadata {} {}{}", new Object[]{metadata, errorType, msg, exception});
        } else {
            this.logger.warn("The metadata {} {}{}", new Object[]{metadata, errorType, msg});
        }
    }

    public void artifactDescriptorInvalid(RepositoryEvent event) {
        String msg = "The POM for {} is invalid, transitive dependencies (if any) will not be available: {}";
        if (this.logger.isDebugEnabled()) {
            this.logger.warn(msg, (Object)event.getArtifact(), (Object)event.getException().getMessage());
        } else {
            this.logger.warn(msg, (Object)event.getArtifact(), (Object)"enable verbose output (-X) for more details");
        }
    }

    public void artifactDescriptorMissing(RepositoryEvent event) {
        this.logger.warn("The POM for {} is missing, no dependency information available", (Object)event.getArtifact());
    }
}

