/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.transformation;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.api.feature.Features;
import org.apache.maven.api.model.DistributionManagement;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.ModelBase;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.model.Repository;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.building.Source;
import org.apache.maven.internal.transformation.TransformedArtifact;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.Result;
import org.apache.maven.model.building.TransformerContext;
import org.apache.maven.model.v4.MavenModelVersion;
import org.apache.maven.model.v4.MavenStaxWriter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.apache.maven.repository.internal.DefaultModelCache;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.installation.InstallRequest;

@Singleton
@Named(value="consumer-pom")
public final class ConsumerPomArtifactTransformer {
    private static final String BOM_PACKAGING = "bom";
    public static final String POM_PACKAGING = "pom";
    private static final String CONSUMER_POM_CLASSIFIER = "consumer";
    private static final String BUILD_POM_CLASSIFIER = "build";
    private static final String NAMESPACE_FORMAT = "http://maven.apache.org/POM/%s";
    private static final String SCHEMA_LOCATION_FORMAT = "https://maven.apache.org/xsd/maven-%s.xsd";
    private final Set<Path> toDelete = new CopyOnWriteArraySet<Path>();
    private final ModelBuilder modelBuilder;

    @Inject
    ConsumerPomArtifactTransformer(ModelBuilder modelBuilder) {
        this.modelBuilder = modelBuilder;
    }

    public void injectTransformedArtifacts(MavenProject project, RepositorySystemSession session) throws IOException {
        if (project.getFile() == null) {
            return;
        }
        if (Features.buildConsumer((Map)session.getUserProperties())) {
            Path buildDir;
            Path path = buildDir = project.getBuild() != null ? Paths.get(project.getBuild().getDirectory(), new String[0]) : null;
            if (buildDir != null) {
                Files.createDirectories(buildDir, new FileAttribute[0]);
            }
            Path consumer = buildDir != null ? Files.createTempFile(buildDir, "consumer-", ".pom", new FileAttribute[0]) : Files.createTempFile("consumer-", ".pom", new FileAttribute[0]);
            this.deferDeleteFile(consumer);
            project.addAttachedArtifact((Artifact)this.createConsumerPomArtifact(project, consumer, session));
        } else if (project.getModel().isRoot()) {
            throw new IllegalStateException("The use of the root attribute on the model requires the buildconsumer feature to be active");
        }
    }

    public ConsumerPomArtifact createConsumerPomArtifact(MavenProject project, Path consumer, RepositorySystemSession session) {
        return new ConsumerPomArtifact(project, consumer, session);
    }

    private void deferDeleteFile(Path generatedFile) {
        this.toDelete.add(generatedFile.toAbsolutePath());
    }

    @PreDestroy
    private void doDeleteFiles() {
        for (Path file : this.toDelete) {
            try {
                Files.delete(file);
            }
            catch (IOException iOException) {}
        }
    }

    public InstallRequest remapInstallArtifacts(RepositorySystemSession session, InstallRequest request) {
        if (Features.buildConsumer((Map)session.getUserProperties()) && this.consumerPomPresent(request.getArtifacts())) {
            request.setArtifacts(this.replacePom(request.getArtifacts()));
        }
        return request;
    }

    public DeployRequest remapDeployArtifacts(RepositorySystemSession session, DeployRequest request) {
        if (Features.buildConsumer((Map)session.getUserProperties()) && this.consumerPomPresent(request.getArtifacts())) {
            request.setArtifacts(this.replacePom(request.getArtifacts()));
        }
        return request;
    }

    private boolean consumerPomPresent(Collection<org.eclipse.aether.artifact.Artifact> artifacts) {
        return artifacts.stream().anyMatch(a -> POM_PACKAGING.equals(a.getExtension()) && CONSUMER_POM_CLASSIFIER.equals(a.getClassifier()));
    }

    private Collection<org.eclipse.aether.artifact.Artifact> replacePom(Collection<org.eclipse.aether.artifact.Artifact> artifacts) {
        ArrayList<org.eclipse.aether.artifact.Artifact> consumers = new ArrayList<org.eclipse.aether.artifact.Artifact>();
        ArrayList<org.eclipse.aether.artifact.Artifact> mains = new ArrayList<org.eclipse.aether.artifact.Artifact>();
        for (org.eclipse.aether.artifact.Artifact artifact : artifacts) {
            if (!POM_PACKAGING.equals(artifact.getExtension()) && !artifact.getExtension().startsWith("pom.")) continue;
            if (CONSUMER_POM_CLASSIFIER.equals(artifact.getClassifier())) {
                consumers.add(artifact);
                continue;
            }
            if (!"".equals(artifact.getClassifier())) continue;
            mains.add(artifact);
        }
        if (!mains.isEmpty() && !consumers.isEmpty()) {
            ArrayList<org.eclipse.aether.artifact.Artifact> result = new ArrayList<org.eclipse.aether.artifact.Artifact>(artifacts);
            for (org.eclipse.aether.artifact.Artifact main : mains) {
                result.remove(main);
                result.add((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(main.getGroupId(), main.getArtifactId(), BUILD_POM_CLASSIFIER, main.getExtension(), main.getVersion(), main.getProperties(), main.getFile()));
            }
            for (org.eclipse.aether.artifact.Artifact consumer : consumers) {
                result.remove(consumer);
                result.add((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(consumer.getGroupId(), consumer.getArtifactId(), "", consumer.getExtension(), consumer.getVersion(), consumer.getProperties(), consumer.getFile()));
            }
            artifacts = result;
        }
        return artifacts;
    }

    private static <T extends ModelBase.Builder> T prune(T builder, ModelBase model) {
        builder.properties(null).reporting(null);
        if (model.getDistributionManagement() != null && model.getDistributionManagement().getRelocation() != null) {
            builder.distributionManagement(DistributionManagement.newBuilder().relocation(model.getDistributionManagement().getRelocation()).build());
        }
        builder.pluginRepositories(ConsumerPomArtifactTransformer.pruneRepositories(model.getPluginRepositories()));
        builder.repositories(ConsumerPomArtifactTransformer.pruneRepositories(model.getRepositories()));
        return builder;
    }

    private static List<Repository> pruneRepositories(List<Repository> repositories) {
        return repositories.stream().filter(r -> !"central".equals(r.getId())).collect(Collectors.toList());
    }

    class ConsumerPomArtifact
    extends TransformedArtifact {
        private MavenProject project;
        private RepositorySystemSession session;

        ConsumerPomArtifact(MavenProject mavenProject, Path target, RepositorySystemSession session) {
            super((Artifact)new ProjectArtifact(mavenProject), () -> mavenProject.getFile().toPath(), ConsumerPomArtifactTransformer.CONSUMER_POM_CLASSIFIER, ConsumerPomArtifactTransformer.POM_PACKAGING, target);
            this.project = mavenProject;
            this.session = session;
        }

        @Override
        public void transform(Path src, Path dest) {
            org.apache.maven.api.model.Model model = this.project.getModel().getDelegate();
            this.transform(src, dest, model);
        }

        void transform(Path src, Path dest, org.apache.maven.api.model.Model model) {
            String version;
            org.apache.maven.api.model.Model consumer = null;
            String packaging = model.getPackaging();
            if (ConsumerPomArtifactTransformer.POM_PACKAGING.equals(packaging)) {
                ModelCache cache = DefaultModelCache.newInstance((RepositorySystemSession)this.session);
                Object modelData = cache.get((Source)new FileModelSource(src.toFile()), "raw");
                if (modelData != null) {
                    try {
                        Method getModel = modelData.getClass().getMethod("getModel", new Class[0]);
                        getModel.setAccessible(true);
                        Model cachedModel = (Model)getModel.invoke(modelData, new Object[0]);
                        consumer = cachedModel.getDelegate();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (consumer == null) {
                    TransformerContext context = (TransformerContext)this.session.getData().get(TransformerContext.KEY);
                    Result result = ConsumerPomArtifactTransformer.this.modelBuilder.buildRawModel(src.toFile(), 0, false, context);
                    if (result.hasErrors()) {
                        throw new IllegalStateException("Unable to build POM " + src, ((ModelProblem)result.getProblems().iterator().next()).getException());
                    }
                    consumer = ((Model)result.get()).getDelegate();
                }
                if ((consumer = consumer.withRoot(false).withModules(null)).getParent() != null) {
                    consumer = consumer.withParent(consumer.getParent().withRelativePath(null));
                }
                if (!consumer.isPreserveModelVersion()) {
                    consumer = consumer.withPreserveModelVersion(false);
                    version = new MavenModelVersion().getModelVersion(consumer);
                    consumer = consumer.withModelVersion(version);
                } else {
                    version = consumer.getModelVersion();
                }
            } else {
                Model.Builder builder = (Model.Builder)ConsumerPomArtifactTransformer.prune((ModelBase.Builder)org.apache.maven.api.model.Model.newBuilder((org.apache.maven.api.model.Model)model, (boolean)true).preserveModelVersion(false).root(false).parent(null).build(null), (ModelBase)model);
                boolean isBom = ConsumerPomArtifactTransformer.BOM_PACKAGING.equals(packaging);
                if (isBom) {
                    builder.packaging(ConsumerPomArtifactTransformer.POM_PACKAGING);
                }
                builder.profiles((Collection)model.getProfiles().stream().map(p -> ((Profile.Builder)ConsumerPomArtifactTransformer.prune((ModelBase.Builder)Profile.newBuilder((Profile)p, (boolean)true), (ModelBase)p)).build()).collect(Collectors.toList()));
                consumer = builder.build();
                version = new MavenModelVersion().getModelVersion(consumer);
                consumer = consumer.withModelVersion(version);
            }
            try {
                Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                try (BufferedWriter w = Files.newBufferedWriter(dest, new OpenOption[0]);){
                    MavenStaxWriter writer = new MavenStaxWriter();
                    writer.setNamespace(String.format(ConsumerPomArtifactTransformer.NAMESPACE_FORMAT, version));
                    writer.setSchemaLocation(String.format(ConsumerPomArtifactTransformer.SCHEMA_LOCATION_FORMAT, version));
                    writer.setAddLocationInformation(false);
                    writer.write((Writer)w, consumer);
                }
            }
            catch (IOException | XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

