/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.model.InputSource;
import org.apache.maven.api.services.xml.ToolchainsXmlFactory;
import org.apache.maven.api.services.xml.XmlReaderException;
import org.apache.maven.api.services.xml.XmlReaderRequest;
import org.apache.maven.api.services.xml.XmlWriterException;
import org.apache.maven.api.services.xml.XmlWriterRequest;
import org.apache.maven.api.toolchain.PersistedToolchains;
import org.apache.maven.toolchain.v4.MavenToolchainsStaxReader;
import org.apache.maven.toolchain.v4.MavenToolchainsStaxWriter;

@Named
@Singleton
public class DefaultToolchainsXmlFactory
implements ToolchainsXmlFactory {
    public PersistedToolchains read(@Nonnull XmlReaderRequest request) throws XmlReaderException {
        Objects.requireNonNull(request, "request can not be null");
        Reader reader = request.getReader();
        InputStream inputStream = request.getInputStream();
        if (reader == null && inputStream == null) {
            throw new IllegalArgumentException("reader or inputStream must be non null");
        }
        try {
            InputSource source = null;
            if (request.getModelId() != null || request.getLocation() != null) {
                source = new InputSource(request.getModelId(), request.getLocation());
            }
            MavenToolchainsStaxReader xml = new MavenToolchainsStaxReader();
            xml.setAddDefaultEntities(request.isAddDefaultEntities());
            if (reader != null) {
                return xml.read(reader, request.isStrict());
            }
            return xml.read(inputStream, request.isStrict());
        }
        catch (Exception e) {
            throw new XmlReaderException("Unable to read toolchains", e);
        }
    }

    public void write(XmlWriterRequest<PersistedToolchains> request) throws XmlWriterException {
        Objects.requireNonNull(request, "request can not be null");
        PersistedToolchains content = Objects.requireNonNull((PersistedToolchains)request.getContent(), "content can not be null");
        OutputStream outputStream = request.getOutputStream();
        Writer writer = request.getWriter();
        if (writer == null && outputStream == null) {
            throw new IllegalArgumentException("writer or outputStream must be non null");
        }
        try {
            if (writer != null) {
                new MavenToolchainsStaxWriter().write(writer, content);
            } else {
                new MavenToolchainsStaxWriter().write(outputStream, content);
            }
        }
        catch (Exception e) {
            throw new XmlWriterException("Unable to write toolchains", e);
        }
    }
}

