/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.ArtifactResolver;
import org.apache.maven.api.services.ArtifactResolverException;
import org.apache.maven.api.services.ArtifactResolverRequest;
import org.apache.maven.api.services.ArtifactResolverResult;
import org.apache.maven.internal.impl.DefaultSession;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Named
@Singleton
public class DefaultArtifactResolver
implements ArtifactResolver {
    private final RepositorySystem repositorySystem;

    @Inject
    DefaultArtifactResolver(@Nonnull RepositorySystem repositorySystem) {
        this.repositorySystem = Utils.nonNull(repositorySystem, "repositorySystem can not be null");
    }

    public ArtifactResolverResult resolve(ArtifactResolverRequest request) throws ArtifactResolverException, IllegalArgumentException {
        Utils.nonNull(request, "request can not be null");
        DefaultSession session = Utils.cast(DefaultSession.class, request.getSession(), "request.session should be a " + DefaultSession.class);
        try {
            List<RemoteRepository> repositories = session.toRepositories(session.getRemoteRepositories());
            List requests = request.getCoordinates().stream().map(coord -> new ArtifactRequest(session.toArtifact((ArtifactCoordinate)coord), repositories, null)).collect(Collectors.toList());
            List results = this.repositorySystem.resolveArtifacts(session.getSession(), requests);
            final HashMap<Artifact, Path> paths = new HashMap<Artifact, Path>();
            for (ArtifactResult result : results) {
                Artifact artifact = session.getArtifact(result.getArtifact());
                Path path = result.getArtifact().getFile().toPath();
                session.getService(ArtifactManager.class).setPath(artifact, path);
                paths.put(artifact, path);
            }
            return new ArtifactResolverResult(){

                public Map<Artifact, Path> getArtifacts() {
                    return paths;
                }
            };
        }
        catch (ArtifactResolutionException e) {
            throw new ArtifactResolverException("Unable to resolve artifact", (Exception)((Object)e));
        }
    }
}

